/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.content.storagecluster;

import com.yahoo.vespa.config.content.PersistenceConfig;
import com.yahoo.vespa.model.builder.xml.dom.ModelElement;
import com.yahoo.vespa.model.utils.Duration;

public class PersistenceProducer
implements PersistenceConfig.Producer {
    Boolean failOnError;
    Duration recoveryPeriod;
    Duration revertTimePeriod;

    public PersistenceProducer() {
    }

    public PersistenceProducer(Boolean failOnError, Duration recoveryPeriod, Duration revertTimePeriod) {
        this.failOnError = failOnError;
        this.recoveryPeriod = recoveryPeriod;
        this.revertTimePeriod = revertTimePeriod;
    }

    public void getConfig(PersistenceConfig.Builder builder) {
        if (this.failOnError != null) {
            builder.fail_partition_on_error(this.failOnError.booleanValue());
        }
        if (this.recoveryPeriod != null) {
            builder.keep_remove_time_period((int)this.recoveryPeriod.getSeconds());
        }
        if (this.revertTimePeriod != null) {
            builder.revert_time_period((int)this.revertTimePeriod.getSeconds());
        }
    }

    public static class Builder {
        public PersistenceProducer build(ModelElement element) {
            ModelElement persistence = element.getChild("engine");
            if (persistence == null) {
                return new PersistenceProducer();
            }
            return new PersistenceProducer(persistence.childAsBoolean("fail-partition-on-error"), persistence.childAsDuration("recovery-time"), persistence.childAsDuration("revert-time"));
        }
    }
}

