/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.http.ssl;

import com.yahoo.component.ComponentId;
import com.yahoo.component.ComponentSpecification;
import com.yahoo.container.bundle.BundleInstantiationSpecification;
import com.yahoo.jdisc.http.ConnectorConfig;
import com.yahoo.jdisc.http.ssl.impl.ConfiguredSslContextFactoryProvider;
import com.yahoo.osgi.provider.model.ComponentModel;
import com.yahoo.vespa.model.container.component.SimpleComponent;
import java.util.List;
import java.util.Optional;

public class ConfiguredFilebasedSslProvider
extends SimpleComponent
implements ConnectorConfig.Producer {
    public static final String COMPONENT_ID_PREFIX = "configured-ssl-provider@";
    public static final String COMPONENT_CLASS = ConfiguredSslContextFactoryProvider.class.getName();
    public static final String COMPONENT_BUNDLE = "jdisc_http_service";
    private final String privateKeyPath;
    private final String certificatePath;
    private final String caCertificatePath;
    private final ConnectorConfig.Ssl.ClientAuth.Enum clientAuthentication;
    private final List<String> cipherSuites;
    private final List<String> protocolVersions;

    public ConfiguredFilebasedSslProvider(String servername, String privateKeyPath, String certificatePath, String caCertificatePath, String clientAuthentication, List<String> cipherSuites, List<String> protocolVersions) {
        super(new ComponentModel(new BundleInstantiationSpecification(new ComponentId(COMPONENT_ID_PREFIX + servername), ComponentSpecification.fromString((String)COMPONENT_CLASS), ComponentSpecification.fromString((String)COMPONENT_BUNDLE))));
        this.privateKeyPath = privateKeyPath;
        this.certificatePath = certificatePath;
        this.caCertificatePath = caCertificatePath;
        this.clientAuthentication = ConfiguredFilebasedSslProvider.mapToConfigEnum(clientAuthentication);
        this.cipherSuites = cipherSuites;
        this.protocolVersions = protocolVersions;
    }

    public void getConfig(ConnectorConfig.Builder builder) {
        builder.ssl(new ConnectorConfig.Ssl.Builder().enabled(true).privateKeyFile(this.privateKeyPath).certificateFile(this.certificatePath).caCertificateFile(Optional.ofNullable(this.caCertificatePath).orElse("")).clientAuth(this.clientAuthentication).enabledCipherSuites(this.cipherSuites).enabledProtocols(this.protocolVersions));
    }

    public SimpleComponent getComponent() {
        return new SimpleComponent(new ComponentModel(this.getComponentId().stringValue(), COMPONENT_CLASS, COMPONENT_BUNDLE));
    }

    private static ConnectorConfig.Ssl.ClientAuth.Enum mapToConfigEnum(String clientAuthValue) {
        if ("disabled".equals(clientAuthValue)) {
            return ConnectorConfig.Ssl.ClientAuth.Enum.DISABLED;
        }
        if ("want".equals(clientAuthValue)) {
            return ConnectorConfig.Ssl.ClientAuth.Enum.WANT_AUTH;
        }
        if ("need".equals(clientAuthValue)) {
            return ConnectorConfig.Ssl.ClientAuth.Enum.NEED_AUTH;
        }
        return ConnectorConfig.Ssl.ClientAuth.Enum.DISABLED;
    }
}

