/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.search;

import com.yahoo.config.model.api.ModelContext;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.searchlib.TranslogserverConfig;
import com.yahoo.vespa.model.AbstractService;
import com.yahoo.vespa.model.PortAllocBridge;
import com.yahoo.vespa.model.builder.xml.dom.VespaDomBuilder;
import org.w3c.dom.Element;

public class TransactionLogServer
extends AbstractService {
    private static final long serialVersionUID = 1L;
    private final boolean useFSync;
    private final TranslogserverConfig.Compression.Type.Enum compressionType;

    private static TranslogserverConfig.Compression.Type.Enum convertCompressionType(String type) {
        try {
            return TranslogserverConfig.Compression.Type.Enum.valueOf((String)type);
        }
        catch (Throwable t) {
            return TranslogserverConfig.Compression.Type.NONE;
        }
    }

    public TransactionLogServer(AbstractConfigProducer searchNode, String clusterName, ModelContext.Properties featureFlags) {
        super(searchNode, "transactionlogserver");
        this.portsMeta.on(0).tag("tls");
        this.setProp("clustername", clusterName);
        this.setProp("clustertype", "search");
        this.useFSync = featureFlags.tlsUseFSync();
        this.compressionType = TransactionLogServer.convertCompressionType(featureFlags.tlsCompressionType());
    }

    @Override
    public int getPortCount() {
        return 1;
    }

    @Override
    public void allocatePorts(int start, PortAllocBridge from) {
        from.allocatePort("tls");
    }

    int getTlsPort() {
        return this.getRelativePort(0);
    }

    private String getTlsDir() {
        return "tls";
    }

    public void getConfig(TranslogserverConfig.Builder builder) {
        builder.listenport(this.getTlsPort()).basedir(this.getTlsDir());
        builder.usefsync(this.useFSync);
        builder.compression.type(this.compressionType);
    }

    public static class Builder
    extends VespaDomBuilder.DomConfigProducerBuilder<TransactionLogServer> {
        private final String clusterName;

        public Builder(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        protected TransactionLogServer doBuild(DeployState deployState, AbstractConfigProducer ancestor, Element producerSpec) {
            return new TransactionLogServer(ancestor, this.clusterName, deployState.getProperties());
        }
    }
}

