/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.content.storagecluster;

import com.yahoo.vespa.config.content.core.StorVisitorConfig;
import com.yahoo.vespa.model.builder.xml.dom.ModelElement;

public class StorVisitorProducer
implements StorVisitorConfig.Producer {
    Integer threadCount;
    Integer maxQueueSize;
    Integer maxConcurrentFixed;
    Integer maxConcurrentVariable;

    public StorVisitorProducer() {
    }

    StorVisitorProducer(Integer threadCount, Integer maxQueueSize, Integer maxConcurrentFixed, Integer maxConcurrentVariable) {
        this.threadCount = threadCount;
        this.maxQueueSize = maxQueueSize;
        this.maxConcurrentFixed = maxConcurrentFixed;
        this.maxConcurrentVariable = maxConcurrentVariable;
    }

    public void getConfig(StorVisitorConfig.Builder builder) {
        if (this.threadCount != null) {
            builder.visitorthreads(this.threadCount.intValue());
        }
        if (this.maxQueueSize != null) {
            builder.maxvisitorqueuesize(this.maxQueueSize.intValue());
        }
        if (this.maxConcurrentFixed != null) {
            builder.maxconcurrentvisitors_fixed(this.maxConcurrentFixed.intValue());
        }
        if (this.maxConcurrentVariable != null) {
            builder.maxconcurrentvisitors_variable(this.maxConcurrentVariable.intValue());
        }
    }

    public static class Builder {
        public StorVisitorProducer build(ModelElement element) {
            ModelElement tuning = element.child("tuning");
            if (tuning == null) {
                return new StorVisitorProducer();
            }
            ModelElement visitors = tuning.child("visitors");
            if (visitors == null) {
                return new StorVisitorProducer();
            }
            return new StorVisitorProducer(visitors.integerAttribute("thread-count"), visitors.integerAttribute("max-queue-size"), visitors.childAsInteger("max-concurrent.fixed"), visitors.childAsInteger("max-concurrent.variable"));
        }
    }
}

