/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.component;

import com.yahoo.container.jdisc.JdiscBindingsConfig;
import com.yahoo.vespa.model.container.component.BindingPattern;
import com.yahoo.vespa.model.container.component.Handler;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class DiscBindingsConfigGenerator {
    public static Map<String, JdiscBindingsConfig.Handlers.Builder> generate(Collection<? extends Handler<?>> handlers) {
        LinkedHashMap<String, JdiscBindingsConfig.Handlers.Builder> handlerBuilders = new LinkedHashMap<String, JdiscBindingsConfig.Handlers.Builder>();
        for (Handler<?> handler : handlers) {
            handlerBuilders.putAll(DiscBindingsConfigGenerator.generate(handler));
        }
        return handlerBuilders;
    }

    public static <T extends Handler<?>> Map<String, JdiscBindingsConfig.Handlers.Builder> generate(T handler) {
        if (handler.getServerBindings().isEmpty() && handler.getClientBindings().isEmpty()) {
            return Collections.emptyMap();
        }
        return Collections.singletonMap(handler.model.getComponentId().stringValue(), new JdiscBindingsConfig.Handlers.Builder().serverBindings(DiscBindingsConfigGenerator.toStrings(handler.getServerBindings())).clientBindings(DiscBindingsConfigGenerator.toStrings(handler.getClientBindings())));
    }

    private static Collection<String> toStrings(Collection<BindingPattern> bindings) {
        return bindings.stream().map(BindingPattern::patternString).collect(Collectors.toList());
    }
}

