/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation.change;

import com.yahoo.config.application.api.ValidationOverrides;
import com.yahoo.config.model.api.ConfigChangeAction;
import com.yahoo.container.QrConfig;
import com.yahoo.vespa.model.VespaModel;
import com.yahoo.vespa.model.application.validation.change.ChangeValidator;
import com.yahoo.vespa.model.application.validation.change.VespaRestartAction;
import com.yahoo.vespa.model.container.Container;
import java.time.Instant;
import java.util.List;
import java.util.stream.Collectors;

public class ContainerRestartValidator
implements ChangeValidator {
    @Override
    public List<ConfigChangeAction> validate(VespaModel currentModel, VespaModel nextModel, ValidationOverrides ignored, Instant now) {
        return nextModel.getContainerClusters().values().stream().flatMap(cluster -> cluster.getContainers().stream()).filter(container -> ContainerRestartValidator.isExistingContainer(container, currentModel)).filter(container -> ContainerRestartValidator.shouldContainerRestartOnDeploy(container, nextModel)).map(ContainerRestartValidator::createConfigChangeAction).collect(Collectors.toList());
    }

    private static ConfigChangeAction createConfigChangeAction(Container container) {
        return new VespaRestartAction(ContainerRestartValidator.createMessage(container), container.getServiceInfo(), true);
    }

    private static String createMessage(Container container) {
        return String.format("Container '%s' is configured to always restart on deploy.", container.getConfigId());
    }

    private static boolean shouldContainerRestartOnDeploy(Container container, VespaModel nextModel) {
        QrConfig config = nextModel.getConfig(QrConfig.class, container.getConfigId());
        return config.restartOnDeploy();
    }

    private static boolean isExistingContainer(Container container, VespaModel currentModel) {
        return currentModel.getService(container.getConfigId()).isPresent();
    }
}

