/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation.change;

import com.yahoo.config.application.api.ValidationId;
import com.yahoo.config.application.api.ValidationOverrides;
import com.yahoo.config.model.api.ConfigChangeAction;
import com.yahoo.config.provision.Capacity;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.vespa.model.VespaModel;
import com.yahoo.vespa.model.application.validation.change.ChangeValidator;
import java.time.Instant;
import java.util.Collections;
import java.util.List;

public class ClusterSizeReductionValidator
implements ChangeValidator {
    @Override
    public List<ConfigChangeAction> validate(VespaModel current, VespaModel next, ValidationOverrides overrides, Instant now) {
        for (ClusterSpec.Id clusterId : current.allClusters()) {
            Capacity currentCapacity = (Capacity)current.provisioned().all().get(clusterId);
            Capacity nextCapacity = (Capacity)next.provisioned().all().get(clusterId);
            if (currentCapacity == null || nextCapacity == null) continue;
            this.validate(currentCapacity, nextCapacity, clusterId, overrides, now);
        }
        return Collections.emptyList();
    }

    private void validate(Capacity current, Capacity next, ClusterSpec.Id clusterId, ValidationOverrides overrides, Instant now) {
        int currentSize = current.minResources().nodes();
        int nextSize = next.minResources().nodes();
        if ((double)nextSize < (double)currentSize * 0.5 && nextSize != currentSize - 1) {
            overrides.invalid(ValidationId.clusterSizeReduction, "Size reduction in '" + clusterId.value() + "' is too large: New min size must be at least 50% of the current min size. Current size: " + currentSize + ", new size: " + nextSize, now);
        }
    }
}

