/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition;

import com.yahoo.config.FileReference;
import com.yahoo.vespa.model.AbstractService;
import com.yahoo.vespa.model.utils.FileSender;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class OnnxModel {
    private final String name;
    private String path = null;
    private String fileReference = "";
    private List<OnnxNameMapping> inputMap = new ArrayList<OnnxNameMapping>();
    private List<OnnxNameMapping> outputMap = new ArrayList<OnnxNameMapping>();
    private PathType pathType = PathType.FILE;

    public PathType getPathType() {
        return this.pathType;
    }

    public OnnxModel(String name) {
        this.name = name;
    }

    public OnnxModel(String name, String fileName) {
        this(name);
        this.path = fileName;
        this.validate();
    }

    public void setFileName(String fileName) {
        Objects.requireNonNull(fileName, "Filename cannot be null");
        this.path = fileName;
        this.pathType = PathType.FILE;
    }

    public void setUri(String uri) {
        Objects.requireNonNull(uri, "uri cannot be null");
        this.path = uri;
        this.pathType = PathType.URI;
    }

    public void addInputNameMapping(String onnxName, String vespaName) {
        Objects.requireNonNull(onnxName, "Onnx name cannot be null");
        Objects.requireNonNull(vespaName, "Vespa name cannot be null");
        this.inputMap.add(new OnnxNameMapping(onnxName, vespaName));
    }

    public void addOutputNameMapping(String onnxName, String vespaName) {
        Objects.requireNonNull(onnxName, "Onnx name cannot be null");
        Objects.requireNonNull(vespaName, "Vespa name cannot be null");
        this.outputMap.add(new OnnxNameMapping(onnxName, vespaName));
    }

    public void sendTo(Collection<? extends AbstractService> services) {
        FileReference reference = this.pathType == PathType.FILE ? FileSender.sendFileToServices(this.path, services) : FileSender.sendUriToServices(this.path, services);
        this.fileReference = reference.value();
    }

    public String getName() {
        return this.name;
    }

    public String getFileName() {
        return this.path;
    }

    public String getUri() {
        return this.path;
    }

    public String getFileReference() {
        return this.fileReference;
    }

    public List<OnnxNameMapping> getInputMap() {
        return Collections.unmodifiableList(this.inputMap);
    }

    public List<OnnxNameMapping> getOutputMap() {
        return Collections.unmodifiableList(this.outputMap);
    }

    public void validate() {
        if (this.path == null || this.path.isEmpty()) {
            throw new IllegalArgumentException("ONNX models must have a file or uri.");
        }
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("onnx-model '").append(this.name).append(this.pathType == PathType.FILE ? "' from file '" : " from uri ").append(this.path).append("' with ref '").append(this.fileReference).append("'");
        return b.toString();
    }

    public static class OnnxNameMapping {
        private String onnxName;
        private String vespaName;

        private OnnxNameMapping(String onnxName, String vespaName) {
            this.onnxName = onnxName;
            this.vespaName = vespaName;
        }

        public String getOnnxName() {
            return this.onnxName;
        }

        public String getVespaName() {
            return this.vespaName;
        }

        public void setVespaName(String vespaName) {
            this.vespaName = vespaName;
        }
    }

    public static enum PathType {
        FILE,
        URI;

    }
}

