/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.model.deploy;

import com.google.common.collect.ImmutableList;
import com.yahoo.config.model.api.ApplicationRoles;
import com.yahoo.config.model.api.ConfigServerSpec;
import com.yahoo.config.model.api.ContainerEndpoint;
import com.yahoo.config.model.api.EndpointCertificateSecrets;
import com.yahoo.config.model.api.ModelContext;
import com.yahoo.config.model.api.Quota;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.AthenzDomain;
import com.yahoo.config.provision.HostName;
import com.yahoo.config.provision.Zone;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class TestProperties
implements ModelContext.Properties {
    private boolean multitenant = false;
    private ApplicationId applicationId = ApplicationId.defaultId();
    private List<ConfigServerSpec> configServerSpecs = Collections.emptyList();
    private boolean hostedVespa = false;
    private Zone zone;
    private final Set<ContainerEndpoint> endpoints = Collections.emptySet();
    private boolean useDedicatedNodeForLogserver = false;
    private boolean useContentNodeBtreeDb = false;
    private boolean useThreePhaseUpdates = false;
    private boolean useDirectStorageApiRpc = false;
    private boolean tlsUseFSync = false;
    private String tlsCompressionType = "NONE";
    private double defaultTermwiseLimit = 1.0;
    private double threadPoolSizeFactor = 0.0;
    private double queueSizeFactor = 0.0;
    private double visibilityDelay = 0.0;
    private String jvmGCOptions = null;
    private String sequencerType = "LATENCY";
    private String responseSequencerType = "ADAPTIVE";
    private int reponseNumThreads = 2;
    private Optional<EndpointCertificateSecrets> endpointCertificateSecrets = Optional.empty();
    private AthenzDomain athenzDomain;
    private ApplicationRoles applicationRoles;
    private Quota quota = Quota.empty();

    public boolean multitenant() {
        return this.multitenant;
    }

    public ApplicationId applicationId() {
        return this.applicationId;
    }

    public List<ConfigServerSpec> configServerSpecs() {
        return this.configServerSpecs;
    }

    public HostName loadBalancerName() {
        return null;
    }

    public URI ztsUrl() {
        return null;
    }

    public String athenzDnsSuffix() {
        return null;
    }

    public boolean hostedVespa() {
        return this.hostedVespa;
    }

    public Zone zone() {
        return this.zone;
    }

    public Set<ContainerEndpoint> endpoints() {
        return this.endpoints;
    }

    public String jvmGCOptions() {
        return this.jvmGCOptions;
    }

    public String feedSequencerType() {
        return this.sequencerType;
    }

    public boolean isBootstrap() {
        return false;
    }

    public boolean isFirstTimeDeployment() {
        return false;
    }

    public boolean useDedicatedNodeForLogserver() {
        return this.useDedicatedNodeForLogserver;
    }

    public Optional<EndpointCertificateSecrets> endpointCertificateSecrets() {
        return this.endpointCertificateSecrets;
    }

    public double defaultTermwiseLimit() {
        return this.defaultTermwiseLimit;
    }

    public double threadPoolSizeFactor() {
        return this.threadPoolSizeFactor;
    }

    public double queueSizeFactor() {
        return this.queueSizeFactor;
    }

    public boolean useContentNodeBtreeDb() {
        return this.useContentNodeBtreeDb;
    }

    public boolean useThreePhaseUpdates() {
        return this.useThreePhaseUpdates;
    }

    public boolean useDirectStorageApiRpc() {
        return this.useDirectStorageApiRpc;
    }

    public Optional<AthenzDomain> athenzDomain() {
        return Optional.ofNullable(this.athenzDomain);
    }

    public Optional<ApplicationRoles> applicationRoles() {
        return Optional.ofNullable(this.applicationRoles);
    }

    public String responseSequencerType() {
        return this.responseSequencerType;
    }

    public int defaultNumResponseThreads() {
        return this.reponseNumThreads;
    }

    public boolean skipCommunicationManagerThread() {
        return false;
    }

    public boolean skipMbusRequestThread() {
        return false;
    }

    public boolean skipMbusReplyThread() {
        return false;
    }

    public Quota quota() {
        return this.quota;
    }

    public double visibilityDelay() {
        return this.visibilityDelay;
    }

    public boolean tlsUseFSync() {
        return this.tlsUseFSync;
    }

    public String tlsCompressionType() {
        return this.tlsCompressionType;
    }

    public TestProperties setJvmGCOptions(String gcOptions) {
        this.jvmGCOptions = gcOptions;
        return this;
    }

    public TestProperties setFeedSequencerType(String type) {
        this.sequencerType = type;
        return this;
    }

    public TestProperties setResponseSequencerType(String type) {
        this.responseSequencerType = type;
        return this;
    }

    public TestProperties setResponseNumThreads(int numThreads) {
        this.reponseNumThreads = numThreads;
        return this;
    }

    public TestProperties setDefaultTermwiseLimit(double limit) {
        this.defaultTermwiseLimit = limit;
        return this;
    }

    public TestProperties setUseContentNodeBtreeDB(boolean useBtreeDb) {
        this.useContentNodeBtreeDb = useBtreeDb;
        return this;
    }

    public TestProperties setUseThreePhaseUpdates(boolean useThreePhaseUpdates) {
        this.useThreePhaseUpdates = useThreePhaseUpdates;
        return this;
    }

    public TestProperties setUseDirectStorageApiRpc(boolean useDirectStorageApiRpc) {
        this.useDirectStorageApiRpc = useDirectStorageApiRpc;
        return this;
    }

    public TestProperties setThreadPoolSizeFactor(double threadPoolSizeFactor) {
        this.threadPoolSizeFactor = threadPoolSizeFactor;
        return this;
    }

    public TestProperties setQueueSizeFactor(double queueSizeFactor) {
        this.queueSizeFactor = queueSizeFactor;
        return this;
    }

    public TestProperties setApplicationId(ApplicationId applicationId) {
        this.applicationId = applicationId;
        return this;
    }

    public TestProperties setHostedVespa(boolean hostedVespa) {
        this.hostedVespa = hostedVespa;
        return this;
    }

    public TestProperties setTlsUseFSync(boolean useFSync) {
        this.tlsUseFSync = useFSync;
        return this;
    }

    public TestProperties setTlsCompressionType(String type) {
        this.tlsCompressionType = type;
        return this;
    }

    public TestProperties setVisibilityDelay(double visibilityDelay) {
        this.visibilityDelay = visibilityDelay;
        return this;
    }

    public TestProperties setMultitenant(boolean multitenant) {
        this.multitenant = multitenant;
        return this;
    }

    public TestProperties setConfigServerSpecs(List<Spec> configServerSpecs) {
        this.configServerSpecs = ImmutableList.copyOf(configServerSpecs);
        return this;
    }

    public TestProperties setUseDedicatedNodeForLogserver(boolean useDedicatedNodeForLogserver) {
        this.useDedicatedNodeForLogserver = useDedicatedNodeForLogserver;
        return this;
    }

    public TestProperties setEndpointCertificateSecrets(Optional<EndpointCertificateSecrets> endpointCertificateSecrets) {
        this.endpointCertificateSecrets = endpointCertificateSecrets;
        return this;
    }

    public TestProperties setZone(Zone zone) {
        this.zone = zone;
        return this;
    }

    public TestProperties setAthenzDomain(AthenzDomain domain) {
        this.athenzDomain = domain;
        return this;
    }

    public TestProperties setApplicationRoles(ApplicationRoles applicationRoles) {
        this.applicationRoles = applicationRoles;
        return this;
    }

    public TestProperties setQuota(Quota quota) {
        this.quota = quota;
        return this;
    }

    public static class Spec
    implements ConfigServerSpec {
        private final String hostName;
        private final int configServerPort;
        private final int zooKeeperPort;

        public String getHostName() {
            return this.hostName;
        }

        public int getConfigServerPort() {
            return this.configServerPort;
        }

        public int getZooKeeperPort() {
            return this.zooKeeperPort;
        }

        public boolean equals(Object o) {
            if (o instanceof ConfigServerSpec) {
                ConfigServerSpec other = (ConfigServerSpec)o;
                return this.hostName.equals(other.getHostName()) && this.configServerPort == other.getConfigServerPort() && this.zooKeeperPort == other.getZooKeeperPort();
            }
            return false;
        }

        public int hashCode() {
            return this.hostName.hashCode();
        }

        public Spec(String hostName, int configServerPort, int zooKeeperPort) {
            this.hostName = hostName;
            this.configServerPort = configServerPort;
            this.zooKeeperPort = zooKeeperPort;
        }
    }
}

