/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.clients;

import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.container.bundle.BundleInstantiationSpecification;
import com.yahoo.osgi.provider.model.ComponentModel;
import com.yahoo.vespa.model.container.ContainerCluster;
import com.yahoo.vespa.model.container.ThreadPoolExecutorComponent;
import com.yahoo.vespa.model.container.component.Handler;
import com.yahoo.vespa.model.container.component.SystemBindingPattern;
import com.yahoo.vespa.model.container.component.UserBindingPattern;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class ContainerDocumentApi {
    private static final int FALLBACK_MAX_POOL_SIZE = 0;
    private static final int FALLBACK_CORE_POOL_SIZE = 0;
    private final ContainerCluster<?> cluster;
    private final Options options;
    private final Handler<AbstractConfigProducer<?>> feedHandler;
    private final Handler<AbstractConfigProducer<?>> restApiHandler;

    public ContainerDocumentApi(ContainerCluster<?> cluster, Options options) {
        this.cluster = cluster;
        this.options = options;
        this.restApiHandler = ContainerDocumentApi.addRestApiHandler(cluster, options);
        this.feedHandler = ContainerDocumentApi.addFeedHandler(cluster, options);
    }

    public void addNodesDependentThreadpoolConfiguration() {
        if (this.cluster.getContainers().isEmpty()) {
            throw new IllegalStateException("Cluster is empty");
        }
        ThreadPoolExecutorComponent feedHandlerExecutor = ContainerDocumentApi.newExecutorComponent("feedapi-handler", this.cluster, this.options);
        this.feedHandler.inject(feedHandlerExecutor);
        this.feedHandler.addComponent(feedHandlerExecutor);
        ThreadPoolExecutorComponent restApiHandlerExecutor = ContainerDocumentApi.newExecutorComponent("restapi-handler", this.cluster, this.options);
        this.restApiHandler.inject(restApiHandlerExecutor);
        this.restApiHandler.addComponent(restApiHandlerExecutor);
    }

    private static Handler<AbstractConfigProducer<?>> addFeedHandler(ContainerCluster<?> cluster, Options options) {
        String bindingSuffix = "/reserved-for-internal-use/feedapi";
        Handler<AbstractConfigProducer<?>> handler = ContainerDocumentApi.newVespaClientHandler("com.yahoo.vespa.http.server.FeedHandler", bindingSuffix, options);
        cluster.addComponent(handler);
        return handler;
    }

    private static Handler<AbstractConfigProducer<?>> addRestApiHandler(ContainerCluster<?> cluster, Options options) {
        Handler<AbstractConfigProducer<?>> handler = ContainerDocumentApi.newVespaClientHandler("com.yahoo.document.restapi.resource.RestApi", "/document/v1/*", options);
        cluster.addComponent(handler);
        return handler;
    }

    private static ThreadPoolExecutorComponent newExecutorComponent(String name, ContainerCluster<?> cluster, Options options) {
        int maxPoolSize = ContainerDocumentApi.maxPoolSize(cluster);
        return new ThreadPoolExecutorComponent.Builder(name).maxPoolSize(maxPoolSize).corePoolSize(ContainerDocumentApi.corePoolSize(maxPoolSize, options)).queueSize(500).build();
    }

    private static Handler<AbstractConfigProducer<?>> newVespaClientHandler(String componentId, String bindingSuffix, Options options) {
        Handler handler = new Handler(new ComponentModel(BundleInstantiationSpecification.getFromStrings((String)componentId, null, (String)"vespaclient-container-plugin"), ""));
        if (options.bindings.isEmpty()) {
            handler.addServerBindings(SystemBindingPattern.fromHttpPath(bindingSuffix), SystemBindingPattern.fromHttpPath(bindingSuffix + "/"));
        } else {
            for (String rootBinding : options.bindings) {
                String pathWithoutLeadingSlash = bindingSuffix.substring(1);
                handler.addServerBindings(UserBindingPattern.fromPattern(rootBinding + pathWithoutLeadingSlash), UserBindingPattern.fromPattern(rootBinding + pathWithoutLeadingSlash + "/"));
            }
        }
        return handler;
    }

    private static int maxPoolSize(ContainerCluster<?> cluster) {
        List vcpus = cluster.getContainers().stream().filter(c -> c.getHostResource() != null && c.getHostResource().realResources() != null).map(c -> c.getHostResource().realResources().vcpu()).distinct().collect(Collectors.toList());
        if (vcpus.size() != 1 || (Double)vcpus.get(0) == 0.0) {
            return 0;
        }
        return Math.max(2, (int)Math.ceil((Double)vcpus.get(0)));
    }

    private static int corePoolSize(int maxPoolSize, Options options) {
        if (maxPoolSize == 0) {
            return 0;
        }
        return Math.max(1, (int)Math.ceil(options.feedCoreThreadPoolSizeFactor * (double)maxPoolSize));
    }

    public static final class Options {
        private final Collection<String> bindings;
        private final double feedCoreThreadPoolSizeFactor;

        public Options(Collection<String> bindings, double feedCoreThreadPoolSizeFactor) {
            this.bindings = Collections.unmodifiableCollection(bindings);
            this.feedCoreThreadPoolSizeFactor = feedCoreThreadPoolSizeFactor;
        }
    }
}

