/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation;

import com.yahoo.config.model.api.Quota;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.provision.Capacity;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.vespa.model.VespaModel;
import com.yahoo.vespa.model.application.validation.Validator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class QuotaValidator
extends Validator {
    @Override
    public void validate(VespaModel model, DeployState deployState) {
        Quota quota = deployState.getProperties().quota();
        quota.maxClusterSize().ifPresent(maxClusterSize -> this.validateMaxClusterSize((int)maxClusterSize, model));
        quota.budget().ifPresent(budget -> this.validateBudget((int)budget, model));
    }

    private void validateBudget(int budget, VespaModel model) {
        Optional<Double> spend = model.allClusters().stream().map(clusterId -> (Capacity)model.provisioned().all().get(clusterId)).map(Capacity::maxResources).map(clusterCapacity -> clusterCapacity.nodeResources().cost() * (double)clusterCapacity.nodes()).reduce(Double::sum);
        if (spend.isPresent() && spend.get() > (double)budget) {
            throw new IllegalArgumentException(String.format("Hourly spend for maximum specified resources ($%.2f) exceeds budget from quota ($%d)!", spend.get(), budget));
        }
    }

    private void validateMaxClusterSize(int maxClusterSize, VespaModel model) {
        List invalidClusters = model.allClusters().stream().filter(clusterId -> {
            Capacity cluster = (Capacity)model.provisioned().all().get(clusterId);
            int clusterSize = cluster.maxResources().nodes();
            return clusterSize > maxClusterSize;
        }).map(ClusterSpec.Id::value).collect(Collectors.toList());
        if (!invalidClusters.isEmpty()) {
            String clusterNames = String.join((CharSequence)", ", invalidClusters);
            throw new IllegalArgumentException("Clusters " + clusterNames + " exceeded max cluster size of " + maxClusterSize);
        }
    }
}

