/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.search;

import com.yahoo.vespa.model.search.IndexedSearchCluster;
import com.yahoo.vespa.model.search.SearchInterface;
import java.util.Map;
import java.util.TreeMap;

public class DispatchGroup {
    private final Map<Integer, Map<Integer, SearchInterface>> searchers = new TreeMap<Integer, Map<Integer, SearchInterface>>();
    private final IndexedSearchCluster sc;

    public DispatchGroup(IndexedSearchCluster sc) {
        this.sc = sc;
    }

    DispatchGroup addSearcher(SearchInterface search) {
        Map<Integer, SearchInterface> rows = this.searchers.get(search.getNodeSpec().partitionId());
        if (rows == null) {
            rows = new TreeMap<Integer, SearchInterface>();
            rows.put(search.getNodeSpec().groupIndex(), search);
            this.searchers.put(search.getNodeSpec().partitionId(), rows);
        } else {
            if (rows.containsKey(search.getNodeSpec().groupIndex())) {
                throw new IllegalArgumentException("Already contains a search node with row id '" + search.getNodeSpec().groupIndex() + "'");
            }
            rows.put(search.getNodeSpec().groupIndex(), search);
        }
        return this;
    }

    public Iterable getSearchersIterable() {
        return new Iterable(this.searchers);
    }

    public int getRowBits() {
        return this.sc.getRowBits();
    }

    public int getNumPartitions() {
        return this.searchers.size();
    }

    public boolean useFixedRowInDispatch() {
        return this.sc.useFixedRowInDispatch();
    }

    public int getSearchableCopies() {
        return this.sc.getSearchableCopies();
    }

    public int getMaxNodesDownPerFixedRow() {
        return this.sc.getMaxNodesDownPerFixedRow();
    }

    public static class Iterable
    implements java.lang.Iterable<SearchInterface> {
        final Map<Integer, Map<Integer, SearchInterface>> searchers;

        Iterable(Map<Integer, Map<Integer, SearchInterface>> searchers) {
            this.searchers = searchers;
        }

        @Override
        public java.util.Iterator<SearchInterface> iterator() {
            return new Iterator(this.searchers);
        }
    }

    static class Iterator
    implements java.util.Iterator<SearchInterface> {
        private java.util.Iterator<Map<Integer, SearchInterface>> it1;
        private java.util.Iterator<SearchInterface> it2;

        Iterator(Map<Integer, Map<Integer, SearchInterface>> s) {
            this.it1 = s.values().iterator();
            if (this.it1.hasNext()) {
                this.it2 = this.it1.next().values().iterator();
            }
        }

        @Override
        public boolean hasNext() {
            if (this.it2 == null) {
                return false;
            }
            while (!this.it2.hasNext() && this.it1.hasNext()) {
                this.it2 = this.it1.next().values().iterator();
            }
            return this.it2.hasNext();
        }

        @Override
        public SearchInterface next() {
            return this.it2.next();
        }

        @Override
        public void remove() {
            throw new IllegalStateException("'remove' not implemented");
        }
    }
}

