/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.http;

import com.yahoo.component.provider.ComponentRegistry;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.jdisc.http.ServerConfig;
import com.yahoo.vespa.model.container.component.chain.ChainedComponent;
import com.yahoo.vespa.model.container.http.AccessControl;
import com.yahoo.vespa.model.container.http.Binding;
import com.yahoo.vespa.model.container.http.FilterChains;
import com.yahoo.vespa.model.container.http.JettyHttpServer;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;

public class Http
extends AbstractConfigProducer<AbstractConfigProducer<?>>
implements ServerConfig.Producer {
    private final FilterChains filterChains;
    private final List<Binding> bindings = new CopyOnWriteArrayList<Binding>();
    private volatile JettyHttpServer httpServer;
    private volatile AccessControl accessControl;

    public Http(FilterChains chains) {
        super("http");
        this.filterChains = chains;
    }

    public void setAccessControl(AccessControl accessControl) {
        if (this.accessControl != null) {
            throw new IllegalStateException("Access control already assigned");
        }
        this.accessControl = accessControl;
    }

    public FilterChains getFilterChains() {
        return this.filterChains;
    }

    public Optional<JettyHttpServer> getHttpServer() {
        return Optional.ofNullable(this.httpServer);
    }

    public void setHttpServer(JettyHttpServer newServer) {
        JettyHttpServer oldServer = this.httpServer;
        this.httpServer = newServer;
        if (oldServer == null && newServer != null) {
            this.addChild(newServer);
        } else if (newServer == null && oldServer != null) {
            this.removeChild(oldServer);
        } else if (newServer != null || oldServer != null) {
            this.removeChild(oldServer);
            this.addChild(newServer);
        }
    }

    public void removeAllServers() {
        this.setHttpServer(null);
    }

    public List<Binding> getBindings() {
        return this.bindings;
    }

    public Optional<AccessControl> getAccessControl() {
        return Optional.ofNullable(this.accessControl);
    }

    public void getConfig(ServerConfig.Builder builder) {
        for (Binding binding : this.bindings) {
            builder.filter(new ServerConfig.Filter.Builder().id(binding.filterId().stringValue()).binding(binding.binding()));
        }
    }

    @Override
    public void validate() {
        if (this.bindings.isEmpty()) {
            return;
        }
        if (this.filterChains == null) {
            throw new IllegalArgumentException("Null FilterChains are not allowed when there are filter bindings");
        }
        ComponentRegistry<ChainedComponent<?>> filters = this.filterChains.componentsRegistry();
        ComponentRegistry chains = this.filterChains.allChains();
        for (Binding binding : this.bindings) {
            if (filters.getComponent(binding.filterId()) != null || chains.getComponent(binding.filterId()) != null) continue;
            throw new RuntimeException("Can't find filter " + binding.filterId() + " for binding " + binding.binding());
        }
    }
}

