/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation.change.search;

import com.yahoo.config.application.api.ValidationOverrides;
import com.yahoo.documentmodel.NewDocumentType;
import com.yahoo.vespa.model.application.validation.change.VespaConfigChangeAction;
import com.yahoo.vespa.model.application.validation.change.search.AttributeChangeValidator;
import com.yahoo.vespa.model.application.validation.change.search.DocumentTypeChangeValidator;
import com.yahoo.vespa.model.application.validation.change.search.IndexingScriptChangeValidator;
import com.yahoo.vespa.model.application.validation.change.search.StructFieldAttributeChangeValidator;
import com.yahoo.vespa.model.search.DocumentDatabase;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;

public class DocumentDatabaseChangeValidator {
    private DocumentDatabase currentDatabase;
    private NewDocumentType currentDocType;
    private DocumentDatabase nextDatabase;
    private NewDocumentType nextDocType;

    public DocumentDatabaseChangeValidator(DocumentDatabase currentDatabase, NewDocumentType currentDocType, DocumentDatabase nextDatabase, NewDocumentType nextDocType) {
        this.currentDatabase = currentDatabase;
        this.currentDocType = currentDocType;
        this.nextDatabase = nextDatabase;
        this.nextDocType = nextDocType;
    }

    public List<VespaConfigChangeAction> validate(ValidationOverrides overrides, Instant now) {
        ArrayList<VespaConfigChangeAction> result = new ArrayList<VespaConfigChangeAction>();
        result.addAll(this.validateAttributeChanges(overrides, now));
        result.addAll(this.validateStructFieldAttributeChanges(overrides, now));
        result.addAll(this.validateIndexingScriptChanges(overrides, now));
        result.addAll(this.validateDocumentTypeChanges(overrides, now));
        return result;
    }

    private List<VespaConfigChangeAction> validateAttributeChanges(ValidationOverrides overrides, Instant now) {
        return new AttributeChangeValidator(this.currentDatabase.getDerivedConfiguration().getAttributeFields(), this.currentDatabase.getDerivedConfiguration().getIndexSchema(), this.currentDocType, this.nextDatabase.getDerivedConfiguration().getAttributeFields(), this.nextDatabase.getDerivedConfiguration().getIndexSchema(), this.nextDocType).validate(overrides, now);
    }

    private List<VespaConfigChangeAction> validateStructFieldAttributeChanges(ValidationOverrides overrides, Instant now) {
        return new StructFieldAttributeChangeValidator(this.currentDocType, this.currentDatabase.getDerivedConfiguration().getAttributeFields(), this.nextDocType, this.nextDatabase.getDerivedConfiguration().getAttributeFields()).validate(overrides, now);
    }

    private List<VespaConfigChangeAction> validateIndexingScriptChanges(ValidationOverrides overrides, Instant now) {
        return new IndexingScriptChangeValidator(this.currentDatabase.getDerivedConfiguration().getSearch(), this.nextDatabase.getDerivedConfiguration().getSearch()).validate(overrides, now);
    }

    private List<VespaConfigChangeAction> validateDocumentTypeChanges(ValidationOverrides overrides, Instant now) {
        return new DocumentTypeChangeValidator(this.currentDocType, this.nextDocType).validate(overrides, now);
    }
}

