/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition;

import com.yahoo.document.Field;
import com.yahoo.document.StructDataType;
import com.yahoo.searchdefinition.FieldOperationApplier;
import com.yahoo.searchdefinition.document.SDDocumentType;
import com.yahoo.searchdefinition.document.SDField;
import java.util.ArrayList;
import java.util.Iterator;

public class FieldOperationApplierForStructs
extends FieldOperationApplier {
    @Override
    public void process(SDDocumentType sdoc) {
        for (SDDocumentType type : sdoc.getAllTypes()) {
            if (!type.isStruct()) continue;
            this.apply(type);
            this.copyFields(type, sdoc);
        }
    }

    private void copyFields(SDDocumentType structType, SDDocumentType sdoc) {
        ArrayList<SDDocumentType> list = new ArrayList<SDDocumentType>();
        list.add(sdoc);
        list.addAll(sdoc.getTypes());
        for (SDDocumentType anyType : list) {
            Iterator<Field> fields = anyType.fieldIterator();
            while (fields.hasNext()) {
                SDField field = (SDField)fields.next();
                StructDataType structUsedByField = field.getFirstStructRecursive();
                if (structUsedByField == null || !structUsedByField.getName().equals(structType.getName())) continue;
                field.populateWithStructFields(sdoc, field.getName(), field.getDataType(), 0);
                field.populateWithStructMatching(sdoc, field.getName(), field.getDataType(), field.getMatching());
            }
        }
    }
}

