/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.model.provision;

import com.yahoo.config.model.api.HostProvisioner;
import com.yahoo.config.model.provision.Host;
import com.yahoo.config.model.provision.Hosts;
import com.yahoo.config.provision.Capacity;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.config.provision.HostSpec;
import com.yahoo.config.provision.ProvisionLogger;
import java.io.Reader;
import java.util.List;
import java.util.Optional;

public class HostsXmlProvisioner
implements HostProvisioner {
    private final Hosts hosts;
    public static final String IMPLICIT_ADMIN_HOSTALIAS = "INTERNAL_VESPA_IMPLICIT_ADMIN";

    public HostsXmlProvisioner(Reader hosts) {
        this.hosts = Hosts.readFrom(hosts);
    }

    public HostSpec allocateHost(String alias) {
        if (alias.equals(IMPLICIT_ADMIN_HOSTALIAS)) {
            if (this.hosts.asCollection().size() > 1) {
                throw new IllegalArgumentException("More than 1 host specified (" + this.hosts.asCollection().size() + ") and <admin> not specified");
            }
            return this.host2HostSpec(this.getFirstHost());
        }
        if (alias.equals("default_singlenode_container")) {
            return this.host2HostSpec(this.getFirstHost());
        }
        for (Host host : this.hosts.asCollection()) {
            if (!host.aliases().contains(alias)) continue;
            return new HostSpec(host.hostname(), host.aliases(), Optional.empty());
        }
        throw new IllegalArgumentException("Unable to find host for alias '" + alias + "'");
    }

    public List<HostSpec> prepare(ClusterSpec cluster, Capacity quantity, ProvisionLogger logger) {
        throw new UnsupportedOperationException("Prepare on an XML host provisioner is not supported");
    }

    private HostSpec host2HostSpec(Host host) {
        return new HostSpec(host.hostname(), host.aliases(), Optional.empty());
    }

    private Host getFirstHost() {
        return this.hosts.asCollection().iterator().next();
    }
}

