/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.http;

import com.yahoo.component.ComponentId;
import com.yahoo.component.ComponentSpecification;
import com.yahoo.container.bundle.BundleInstantiationSpecification;
import com.yahoo.jdisc.http.ServerConfig;
import com.yahoo.osgi.provider.model.ComponentModel;
import com.yahoo.vespa.model.container.component.SimpleComponent;
import com.yahoo.vespa.model.container.http.ConnectorFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class JettyHttpServer
extends SimpleComponent
implements ServerConfig.Producer {
    private List<ConnectorFactory> connectorFactories = new ArrayList<ConnectorFactory>();

    public JettyHttpServer(ComponentId id) {
        super(new ComponentModel(new BundleInstantiationSpecification(id, ComponentSpecification.fromString((String)"com.yahoo.jdisc.http.server.jetty.JettyHttpServer"), ComponentSpecification.fromString((String)"jdisc_http_service"))));
        FilterBindingsProviderComponent filterBindingsProviderComponent = new FilterBindingsProviderComponent(id);
        this.addChild(filterBindingsProviderComponent);
        this.inject(filterBindingsProviderComponent);
    }

    public void addConnector(ConnectorFactory connectorFactory) {
        this.connectorFactories.add(connectorFactory);
        this.addChild(connectorFactory);
    }

    public void removeConnector(ConnectorFactory connectorFactory) {
        if (connectorFactory == null) {
            return;
        }
        this.removeChild(connectorFactory);
        this.connectorFactories.remove(connectorFactory);
    }

    public List<ConnectorFactory> getConnectorFactories() {
        return Collections.unmodifiableList(this.connectorFactories);
    }

    public void getConfig(ServerConfig.Builder builder) {
        builder.metric(new ServerConfig.Metric.Builder().monitoringHandlerPaths(List.of("/state/v1", "/status.html")).searchHandlerPaths(List.of("/search")));
    }

    static ComponentModel providerComponentModel(ComponentId parentId, String className) {
        ComponentSpecification classNameSpec = new ComponentSpecification(className);
        return new ComponentModel(new BundleInstantiationSpecification(classNameSpec.nestInNamespace(parentId), classNameSpec, null));
    }

    public static final class FilterBindingsProviderComponent
    extends SimpleComponent {
        public FilterBindingsProviderComponent(ComponentId parentId) {
            super(JettyHttpServer.providerComponentModel(parentId, "com.yahoo.container.jdisc.FilterBindingsProvider"));
        }
    }
}

