/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation.first;

import com.yahoo.collections.CollectionUtil;
import com.yahoo.config.application.api.ValidationId;
import com.yahoo.config.model.ConfigModelContext;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.provision.InstanceName;
import com.yahoo.vespa.model.VespaModel;
import com.yahoo.vespa.model.application.validation.Validator;
import com.yahoo.vespa.model.container.ApplicationContainerCluster;
import com.yahoo.vespa.model.container.ContainerCluster;
import com.yahoo.vespa.model.container.http.AccessControl;
import java.util.ArrayList;

public class AccessControlOnFirstDeploymentValidator
extends Validator {
    @Override
    public void validate(VespaModel model, DeployState deployState) {
        if (!AccessControlOnFirstDeploymentValidator.needsAccessControlValidation(model, deployState)) {
            return;
        }
        ArrayList<String> offendingClusters = new ArrayList<String>();
        for (ContainerCluster containerCluster : model.getContainerClusters().values()) {
            ApplicationContainerCluster cluster;
            if (!(containerCluster instanceof ApplicationContainerCluster) || (cluster = (ApplicationContainerCluster)containerCluster).getHttp() != null && cluster.getHttp().getAccessControl().isPresent() && cluster.getHttp().getAccessControl().get().writeEnabled || !AccessControl.hasHandlerThatNeedsProtection(cluster) && cluster.getAllServlets().isEmpty()) continue;
            offendingClusters.add(cluster.getName());
        }
        if (!offendingClusters.isEmpty()) {
            deployState.validationOverrides().invalid(ValidationId.accessControl, "Access-control must be enabled for write operations to container clusters in production zones: " + CollectionUtil.mkString(offendingClusters, (String)"[", (String)", ", (String)"]"), deployState.now());
        }
    }

    public static boolean needsAccessControlValidation(VespaModel model, DeployState deployState) {
        if (!deployState.isHosted()) {
            return false;
        }
        if (!deployState.zone().environment().isProduction()) {
            return false;
        }
        if (deployState.zone().system().isPublic()) {
            return false;
        }
        if (!deployState.getApplicationPackage().getApplicationId().instance().equals((Object)InstanceName.defaultName())) {
            return false;
        }
        return model.getAdmin().getApplicationType() == ConfigModelContext.ApplicationType.DEFAULT;
    }
}

