/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.search;

import com.yahoo.vespa.model.content.DispatchSpec;
import com.yahoo.vespa.model.search.SearchNode;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class MultilevelDispatchValidator {
    private final String clusterName;
    private final DispatchSpec dispatchSpec;
    private final List<SearchNode> searchNodes;

    public MultilevelDispatchValidator(String clusterName, DispatchSpec dispatchSpec, List<SearchNode> searchNodes) {
        this.clusterName = clusterName;
        this.dispatchSpec = dispatchSpec;
        this.searchNodes = searchNodes;
    }

    public void validate() {
        this.validateThatWeReferenceNodesOnlyOnce();
        this.validateThatWeReferenceAllNodes();
        this.validateThatWeUseValidNodeReferences();
    }

    private void validateThatWeReferenceNodesOnlyOnce() {
        HashSet<Integer> distKeys = new HashSet<Integer>();
        for (DispatchSpec.Group group : this.dispatchSpec.getGroups()) {
            for (DispatchSpec.Node node : group.getNodes()) {
                int distKey = node.getDistributionKey();
                if (distKeys.contains(distKey)) {
                    throw new IllegalArgumentException(this.getErrorMsgPrefix() + "Expected nodes to be referenced only once in dispatch groups, but node with distribution key '" + distKey + "' is referenced multiple times.");
                }
                distKeys.add(distKey);
            }
        }
    }

    private void validateThatWeReferenceAllNodes() {
        Set<Integer> distKeys = this.createDistributionKeysSet();
        for (DispatchSpec.Group group : this.dispatchSpec.getGroups()) {
            for (DispatchSpec.Node node : group.getNodes()) {
                distKeys.remove(node.getDistributionKey());
            }
        }
        if (!distKeys.isEmpty()) {
            Object[] sorted = distKeys.toArray();
            Arrays.sort(sorted);
            throw new IllegalArgumentException(this.getErrorMsgPrefix() + "Expected all nodes to be referenced in dispatch groups, but " + distKeys.size() + " node(s) with distribution keys " + Arrays.toString(sorted) + " are not referenced.");
        }
    }

    private void validateThatWeUseValidNodeReferences() {
        Set<Integer> distKeys = this.createDistributionKeysSet();
        for (DispatchSpec.Group group : this.dispatchSpec.getGroups()) {
            for (DispatchSpec.Node node : group.getNodes()) {
                int distKey = node.getDistributionKey();
                if (distKeys.contains(distKey)) continue;
                throw new IllegalArgumentException(this.getErrorMsgPrefix() + "Expected all node references in dispatch groups to reference existing nodes, but node with distribution key '" + distKey + "' does not exists.");
            }
        }
    }

    private Set<Integer> createDistributionKeysSet() {
        HashSet<Integer> distKeys = new HashSet<Integer>();
        for (SearchNode node : this.searchNodes) {
            distKeys.add(node.getDistributionKey());
        }
        return distKeys;
    }

    private String getErrorMsgPrefix() {
        return "In indexed content cluster '" + this.clusterName + "': ";
    }
}

