/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.http.ssl;

import com.yahoo.config.model.api.EndpointCertificateSecrets;
import com.yahoo.jdisc.http.ConnectorConfig;
import com.yahoo.vespa.model.container.component.SimpleComponent;
import com.yahoo.vespa.model.container.http.ConnectorFactory;
import com.yahoo.vespa.model.container.http.ssl.ConfiguredDirectSslProvider;
import com.yahoo.vespa.model.container.http.ssl.DefaultSslProvider;
import java.time.Duration;
import java.util.List;

public class HostedSslConnectorFactory
extends ConnectorFactory {
    private static final List<String> INSECURE_WHITELISTED_PATHS = List.of("/status.html");
    private static final String DEFAULT_HOSTED_TRUSTSTORE = "/opt/yahoo/share/ssl/certs/athenz_certificate_bundle.pem";
    private final boolean enableProxyProtocol;
    private final boolean enforceClientAuth;

    public static HostedSslConnectorFactory withProvidedCertificate(String serverName, EndpointCertificateSecrets endpointCertificateSecrets, boolean enableProxyProtocol) {
        return new HostedSslConnectorFactory(HostedSslConnectorFactory.createConfiguredDirectSslProvider(serverName, endpointCertificateSecrets, DEFAULT_HOSTED_TRUSTSTORE, null), false, enableProxyProtocol);
    }

    public static HostedSslConnectorFactory withProvidedCertificateAndTruststore(String serverName, EndpointCertificateSecrets endpointCertificateSecrets, String tlsCaCertificates, boolean enableProxyProtocol) {
        return new HostedSslConnectorFactory(HostedSslConnectorFactory.createConfiguredDirectSslProvider(serverName, endpointCertificateSecrets, null, tlsCaCertificates), true, enableProxyProtocol);
    }

    public static HostedSslConnectorFactory withDefaultCertificateAndTruststore(String serverName, boolean enableProxyProtocol) {
        return new HostedSslConnectorFactory(new DefaultSslProvider(serverName), true, enableProxyProtocol);
    }

    private HostedSslConnectorFactory(SimpleComponent sslProviderComponent, boolean enforceClientAuth, boolean enableProxyProtocol) {
        super("tls4443", 4443, sslProviderComponent);
        this.enforceClientAuth = enforceClientAuth;
        this.enableProxyProtocol = enableProxyProtocol;
    }

    private static ConfiguredDirectSslProvider createConfiguredDirectSslProvider(String serverName, EndpointCertificateSecrets endpointCertificateSecrets, String tlsCaCertificatesPath, String tlsCaCertificates) {
        return new ConfiguredDirectSslProvider(serverName, endpointCertificateSecrets.key(), endpointCertificateSecrets.certificate(), tlsCaCertificatesPath, tlsCaCertificates, ConnectorConfig.Ssl.ClientAuth.Enum.WANT_AUTH);
    }

    @Override
    public void getConfig(ConnectorConfig.Builder connectorBuilder) {
        super.getConfig(connectorBuilder);
        connectorBuilder.tlsClientAuthEnforcer(new ConnectorConfig.TlsClientAuthEnforcer.Builder().pathWhitelist(INSECURE_WHITELISTED_PATHS).enable(this.enforceClientAuth)).proxyProtocol(new ConnectorConfig.ProxyProtocol.Builder().enabled(this.enableProxyProtocol).mixedMode(true)).idleTimeout((double)Duration.ofMinutes(3L).toSeconds()).maxConnectionLife((double)Duration.ofMinutes(10L).toSeconds());
    }
}

