/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container;

import com.yahoo.cloud.config.ClusterInfoConfig;
import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.cloud.config.RoutingProviderConfig;
import com.yahoo.component.ComponentId;
import com.yahoo.concurrent.classlock.ClassLocking;
import com.yahoo.config.application.api.ApplicationMetaData;
import com.yahoo.config.docproc.DocprocConfig;
import com.yahoo.config.docproc.SchemamappingConfig;
import com.yahoo.config.model.ApplicationConfigProducerRoot;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.config.provision.Zone;
import com.yahoo.container.BundlesConfig;
import com.yahoo.container.ComponentsConfig;
import com.yahoo.container.QrSearchersConfig;
import com.yahoo.container.bundle.BundleInstantiationSpecification;
import com.yahoo.container.core.ApplicationMetadataConfig;
import com.yahoo.container.core.document.ContainerDocumentConfig;
import com.yahoo.container.handler.ClustersStatus;
import com.yahoo.container.handler.LogHandler;
import com.yahoo.container.handler.ThreadpoolConfig;
import com.yahoo.container.jdisc.JdiscBindingsConfig;
import com.yahoo.container.jdisc.LoggingRequestHandler;
import com.yahoo.container.jdisc.config.HealthMonitorConfig;
import com.yahoo.container.logging.AccessLog;
import com.yahoo.container.usability.BindingsOverviewHandler;
import com.yahoo.container.xml.providers.DatatypeFactoryProvider;
import com.yahoo.container.xml.providers.DocumentBuilderFactoryProvider;
import com.yahoo.container.xml.providers.SAXParserFactoryProvider;
import com.yahoo.container.xml.providers.SchemaFactoryProvider;
import com.yahoo.container.xml.providers.TransformerFactoryProvider;
import com.yahoo.container.xml.providers.XMLEventFactoryProvider;
import com.yahoo.container.xml.providers.XMLInputFactoryProvider;
import com.yahoo.container.xml.providers.XMLOutputFactoryProvider;
import com.yahoo.container.xml.providers.XPathFactoryProvider;
import com.yahoo.document.config.DocumentmanagerConfig;
import com.yahoo.jdisc.http.filter.SecurityFilterInvoker;
import com.yahoo.metrics.simple.MetricManager;
import com.yahoo.metrics.simple.jdisc.JdiscMetricsFactory;
import com.yahoo.osgi.provider.model.ComponentModel;
import com.yahoo.prelude.semantics.SemanticRulesConfig;
import com.yahoo.search.config.IndexInfoConfig;
import com.yahoo.search.config.QrStartConfig;
import com.yahoo.search.pagetemplates.PageTemplatesConfig;
import com.yahoo.search.query.profile.config.QueryProfilesConfig;
import com.yahoo.vespa.configdefinition.IlscriptsConfig;
import com.yahoo.vespa.model.AbstractService;
import com.yahoo.vespa.model.PortsMeta;
import com.yahoo.vespa.model.Service;
import com.yahoo.vespa.model.admin.monitoring.Monitoring;
import com.yahoo.vespa.model.clients.ContainerDocumentApi;
import com.yahoo.vespa.model.container.Container;
import com.yahoo.vespa.model.container.SecretStore;
import com.yahoo.vespa.model.container.ThreadPoolExecutorComponent;
import com.yahoo.vespa.model.container.component.AccessLogComponent;
import com.yahoo.vespa.model.container.component.Component;
import com.yahoo.vespa.model.container.component.ComponentGroup;
import com.yahoo.vespa.model.container.component.ComponentsConfigGenerator;
import com.yahoo.vespa.model.container.component.DiscBindingsConfigGenerator;
import com.yahoo.vespa.model.container.component.Handler;
import com.yahoo.vespa.model.container.component.SimpleComponent;
import com.yahoo.vespa.model.container.component.StatisticsComponent;
import com.yahoo.vespa.model.container.component.chain.ProcessingHandler;
import com.yahoo.vespa.model.container.docproc.ContainerDocproc;
import com.yahoo.vespa.model.container.docproc.DocprocChains;
import com.yahoo.vespa.model.container.http.Http;
import com.yahoo.vespa.model.container.processing.ProcessingChains;
import com.yahoo.vespa.model.container.search.ContainerSearch;
import com.yahoo.vespa.model.container.search.searchchain.SearchChains;
import com.yahoo.vespa.model.content.Content;
import com.yahoo.vespa.model.search.AbstractSearchCluster;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public abstract class ContainerCluster<CONTAINER extends Container>
extends AbstractConfigProducer<AbstractConfigProducer<?>>
implements ComponentsConfig.Producer,
JdiscBindingsConfig.Producer,
DocumentmanagerConfig.Producer,
ContainerDocumentConfig.Producer,
HealthMonitorConfig.Producer,
ApplicationMetadataConfig.Producer,
BundlesConfig.Producer,
IndexInfoConfig.Producer,
IlscriptsConfig.Producer,
SchemamappingConfig.Producer,
QrSearchersConfig.Producer,
QrStartConfig.Producer,
QueryProfilesConfig.Producer,
PageTemplatesConfig.Producer,
SemanticRulesConfig.Producer,
DocprocConfig.Producer,
ClusterInfoConfig.Producer,
RoutingProviderConfig.Producer,
ConfigserverConfig.Producer,
ThreadpoolConfig.Producer {
    public static final String RESERVED_URI_PREFIX = "reserved-for-internal-use";
    public static final String APPLICATION_STATUS_HANDLER_CLASS = "com.yahoo.container.handler.observability.ApplicationStatusHandler";
    public static final String BINDINGS_OVERVIEW_HANDLER_CLASS = BindingsOverviewHandler.class.getName();
    public static final String LOG_HANDLER_CLASS = LogHandler.class.getName();
    public static final String DEFAULT_LINGUISTICS_PROVIDER = "com.yahoo.language.provider.DefaultLinguisticsProvider";
    public static final String CMS = "-XX:+UseConcMarkSweepGC -XX:MaxTenuringThreshold=15 -XX:NewRatio=1";
    public static final String G1GC = "-XX:+UseG1GC -XX:MaxTenuringThreshold=15";
    public static final String STATE_HANDLER_CLASS = "com.yahoo.container.jdisc.state.StateHandler";
    public static final String STATE_HANDLER_BINDING_1 = "http://*/state/v1";
    public static final String STATE_HANDLER_BINDING_2 = "http://*/state/v1/*";
    public static final String ROOT_HANDLER_PATH = "/";
    public static final String ROOT_HANDLER_BINDING = "http://*/";
    public static final String VIP_HANDLER_BINDING = "http://*/status.html";
    private final String name;
    protected List<CONTAINER> containers = new ArrayList<CONTAINER>();
    private Http http;
    private ProcessingChains processingChains;
    private ContainerSearch containerSearch;
    private ContainerDocproc containerDocproc;
    private ContainerDocumentApi containerDocumentApi;
    private SecretStore secretStore;
    private boolean rpcServerEnabled = true;
    private boolean httpServerEnabled = true;
    private final Set<Path> platformBundles = new LinkedHashSet<Path>();
    private final List<String> serviceAliases = new ArrayList<String>();
    private final List<String> endpointAliases = new ArrayList<String>();
    private final ComponentGroup<Component<?, ?>> componentGroup;
    private final boolean isHostedVespa;
    private Map<String, String> concreteDocumentTypes = new LinkedHashMap<String, String>();
    private ApplicationMetaData applicationMetaData = null;
    private Zone zone;
    private String hostClusterId = null;
    private String jvmGCOptions = null;
    private String environmentVars = null;
    private final double threadPoolSizeFactor;
    private final double queueSizeFactor;

    public ContainerCluster(AbstractConfigProducer<?> parent, String subId, String name, DeployState deployState) {
        super(parent, subId);
        this.name = name;
        this.isHostedVespa = ContainerCluster.stateIsHosted(deployState);
        this.zone = deployState != null ? deployState.zone() : Zone.defaultZone();
        this.threadPoolSizeFactor = deployState.getProperties().threadPoolSizeFactor();
        this.queueSizeFactor = deployState.getProperties().queueSizeFactor();
        this.componentGroup = new ComponentGroup(this, "component");
        this.addComponent(new StatisticsComponent());
        this.addSimpleComponent(AccessLog.class);
        this.addComponent(new ThreadPoolExecutorComponent.Builder("default-pool").build());
        this.addSimpleComponent(ClassLocking.class);
        this.addSimpleComponent(SecurityFilterInvoker.class);
        this.addSimpleComponent("com.yahoo.container.jdisc.metric.MetricConsumerProviderProvider");
        this.addSimpleComponent("com.yahoo.container.jdisc.metric.MetricProvider");
        this.addSimpleComponent("com.yahoo.container.jdisc.metric.MetricUpdater");
        this.addSimpleComponent(LoggingRequestHandler.Context.class);
        this.addSimpleComponent(MetricManager.class.getName(), null, "simplemetrics");
        this.addSimpleComponent(JdiscMetricsFactory.class.getName(), null, "simplemetrics");
        this.addSimpleComponent("com.yahoo.container.jdisc.state.StateMonitor");
        this.addSimpleComponent("com.yahoo.container.jdisc.ContainerThreadFactory");
        this.addSimpleComponent("com.yahoo.container.handler.VipStatus");
        this.addSimpleComponent(ClustersStatus.class.getName());
        this.addJaxProviders();
    }

    public double getThreadPoolSizeFactor() {
        return this.threadPoolSizeFactor;
    }

    public double getQueueSizeFactor() {
        return this.queueSizeFactor;
    }

    public void setZone(Zone zone) {
        this.zone = zone;
    }

    public Zone getZone() {
        return this.zone;
    }

    public void addDefaultHandlersWithVip() {
        this.addDefaultHandlersExceptStatus();
        this.addVipHandler();
    }

    public final void addDefaultHandlersExceptStatus() {
        this.addDefaultRootHandler();
        this.addMetricStateHandler();
        this.addApplicationStatusHandler();
    }

    public void addMetricStateHandler() {
        Handler stateHandler = new Handler(new ComponentModel(STATE_HANDLER_CLASS, null, null, null));
        stateHandler.addServerBindings(STATE_HANDLER_BINDING_1, STATE_HANDLER_BINDING_2);
        this.addComponent(stateHandler);
    }

    public void addDefaultRootHandler() {
        Handler handler = new Handler(new ComponentModel(BundleInstantiationSpecification.getFromStrings((String)BINDINGS_OVERVIEW_HANDLER_CLASS, null, null), null));
        handler.addServerBindings(ROOT_HANDLER_BINDING);
        this.addComponent(handler);
    }

    public void addApplicationStatusHandler() {
        Handler statusHandler = new Handler(new ComponentModel(BundleInstantiationSpecification.getInternalHandlerSpecificationFromStrings((String)APPLICATION_STATUS_HANDLER_CLASS, null), null));
        statusHandler.addServerBindings("http://*/ApplicationStatus");
        this.addComponent(statusHandler);
    }

    public void addVipHandler() {
        Handler<AbstractConfigProducer<?>> vipHandler = Handler.fromClassName("com.yahoo.container.handler.VipStatusHandler");
        vipHandler.addServerBindings(VIP_HANDLER_BINDING);
        this.addComponent(vipHandler);
    }

    private void addJaxProviders() {
        this.addSimpleComponent(DatatypeFactoryProvider.class);
        this.addSimpleComponent(DocumentBuilderFactoryProvider.class);
        this.addSimpleComponent(SAXParserFactoryProvider.class);
        this.addSimpleComponent(SchemaFactoryProvider.class);
        this.addSimpleComponent(TransformerFactoryProvider.class);
        this.addSimpleComponent(XMLEventFactoryProvider.class);
        this.addSimpleComponent(XMLInputFactoryProvider.class);
        this.addSimpleComponent(XMLOutputFactoryProvider.class);
        this.addSimpleComponent(XPathFactoryProvider.class);
    }

    public final void addComponent(Component<?, ?> component) {
        this.componentGroup.addComponent(component);
    }

    public final void addSimpleComponent(String idSpec, String classSpec, String bundleSpec) {
        this.addComponent(new SimpleComponent(new ComponentModel(idSpec, classSpec, bundleSpec)));
    }

    public Component removeComponent(ComponentId componentId) {
        return (Component)this.componentGroup.removeComponent(componentId);
    }

    private void addSimpleComponent(Class<?> clazz) {
        this.addSimpleComponent(clazz.getName());
    }

    protected void addSimpleComponent(String className) {
        this.addComponent(new SimpleComponent(className));
    }

    public void prepare(DeployState deployState) {
        this.applicationMetaData = deployState.getApplicationPackage().getMetaData();
        this.doPrepare(deployState);
    }

    protected abstract void doPrepare(DeployState var1);

    public String getName() {
        return this.name;
    }

    public List<CONTAINER> getContainers() {
        return Collections.unmodifiableList(this.containers);
    }

    public void addContainer(CONTAINER container) {
        ((Container)container).setClusterName(this.name);
        ((AbstractService)container).setProp("clustername", this.name).setProp("index", this.containers.size());
        this.containers.add(container);
    }

    public void addContainers(Collection<CONTAINER> containers) {
        containers.forEach(this::addContainer);
    }

    public void setProcessingChains(ProcessingChains processingChains, String ... serverBindings) {
        if (this.processingChains != null) {
            throw new IllegalStateException("ProcessingChains should only be set once.");
        }
        this.processingChains = processingChains;
        ProcessingHandler<ProcessingChains> processingHandler = new ProcessingHandler<ProcessingChains>(processingChains, "com.yahoo.processing.handler.ProcessingHandler");
        for (String binding : serverBindings) {
            processingHandler.addServerBindings(binding);
        }
        this.addComponent(processingHandler);
    }

    ProcessingChains getProcessingChains() {
        return this.processingChains;
    }

    public SearchChains getSearchChains() {
        if (this.containerSearch == null) {
            throw new IllegalStateException("Search components not found in container cluster '" + this.getSubId() + "': Add <search/> to the cluster in services.xml");
        }
        return (SearchChains)this.containerSearch.getChains();
    }

    public ContainerSearch getSearch() {
        return this.containerSearch;
    }

    public void setSearch(ContainerSearch containerSearch) {
        this.containerSearch = containerSearch;
    }

    public void setHttp(Http http) {
        this.http = http;
        this.addChild(http);
    }

    public Http getHttp() {
        return this.http;
    }

    public ContainerDocproc getDocproc() {
        return this.containerDocproc;
    }

    public void setDocproc(ContainerDocproc containerDocproc) {
        this.containerDocproc = containerDocproc;
    }

    public ContainerDocumentApi getDocumentApi() {
        return this.containerDocumentApi;
    }

    public void setDocumentApi(ContainerDocumentApi containerDocumentApi) {
        this.containerDocumentApi = containerDocumentApi;
    }

    public DocprocChains getDocprocChains() {
        if (this.containerDocproc == null) {
            throw new IllegalStateException("Document processing components not found in container cluster '" + this.getSubId() + "': Add <document-processing/> to the cluster in services.xml");
        }
        return (DocprocChains)this.containerDocproc.getChains();
    }

    public Collection<Handler<?>> getHandlers() {
        return this.componentGroup.getComponents(Handler.class);
    }

    public void setSecretStore(SecretStore secretStore) {
        this.secretStore = secretStore;
    }

    public Optional<SecretStore> getSecretStore() {
        return Optional.ofNullable(this.secretStore);
    }

    public Map<ComponentId, Component<?, ?>> getComponentsMap() {
        return this.componentGroup.getComponentMap();
    }

    public Collection<Component<?, ?>> getAllComponents() {
        ArrayList allComponents = new ArrayList();
        this.recursivelyFindAllComponents(allComponents, this);
        Collections.sort(allComponents);
        return Collections.unmodifiableCollection(allComponents);
    }

    private void recursivelyFindAllComponents(Collection<Component<?, ?>> allComponents, AbstractConfigProducer<?> current) {
        for (AbstractConfigProducer child : current.getChildren().values()) {
            if (child instanceof Component) {
                allComponents.add((Component)child);
            }
            if (child instanceof Container) continue;
            this.recursivelyFindAllComponents(allComponents, child);
        }
    }

    public void getConfig(ComponentsConfig.Builder builder) {
        builder.components.addAll(ComponentsConfigGenerator.generate(this.getAllComponents()));
        builder.components(new ComponentsConfig.Components.Builder().id("com.yahoo.container.core.config.HandlersConfigurerDi$RegistriesHack"));
    }

    public void getConfig(JdiscBindingsConfig.Builder builder) {
        builder.handlers.putAll(DiscBindingsConfigGenerator.generate(this.getHandlers()));
    }

    public void getConfig(DocumentmanagerConfig.Builder builder) {
        if (this.containerDocproc != null && this.containerDocproc.isCompressDocuments()) {
            builder.enablecompression(true);
        }
    }

    public void getConfig(ContainerDocumentConfig.Builder builder) {
        for (Map.Entry<String, String> e : this.concreteDocumentTypes.entrySet()) {
            ContainerDocumentConfig.Doctype.Builder dtb = new ContainerDocumentConfig.Doctype.Builder();
            dtb.type(e.getKey());
            dtb.factorycomponent(e.getValue());
            builder.doctype(dtb);
        }
    }

    public void getConfig(HealthMonitorConfig.Builder builder) {
        Monitoring monitoring = this.getMonitoringService();
        if (monitoring != null) {
            builder.snapshot_interval((double)monitoring.getIntervalSeconds().intValue());
        }
    }

    public void getConfig(ApplicationMetadataConfig.Builder builder) {
        if (this.applicationMetaData != null) {
            builder.name(this.applicationMetaData.getApplicationId().application().value()).user(this.applicationMetaData.getDeployedByUser()).path(this.applicationMetaData.getDeployPath()).timestamp(this.applicationMetaData.getDeployTimestamp().longValue()).checksum(this.applicationMetaData.getChecksum()).generation(this.applicationMetaData.getGeneration().longValue());
        }
    }

    public final void addPlatformBundle(Path bundlePath) {
        this.platformBundles.add(bundlePath);
    }

    public void getConfig(BundlesConfig.Builder builder) {
        this.platformBundles.stream().map(ContainerCluster::toFileReferenceString).forEach(arg_0 -> ((BundlesConfig.Builder)builder).bundle(arg_0));
    }

    private static String toFileReferenceString(Path path) {
        return "file:" + path.toString();
    }

    public void getConfig(QrSearchersConfig.Builder builder) {
        if (this.containerSearch != null) {
            this.containerSearch.getConfig(builder);
        }
    }

    public void getConfig(QrStartConfig.Builder builder) {
        builder.jvm.verbosegc(false).availableProcessors(2).compressedClassSpaceSize(32).minHeapsize(32).heapsize(512).heapSizeAsPercentageOfPhysicalMemory(0).gcopts(Objects.requireNonNullElse(this.jvmGCOptions, G1GC));
        if (this.environmentVars != null) {
            builder.qrs.env(this.environmentVars);
        }
    }

    public void getConfig(DocprocConfig.Builder builder) {
        if (this.containerDocproc != null) {
            this.containerDocproc.getConfig(builder);
        }
    }

    public void getConfig(PageTemplatesConfig.Builder builder) {
        if (this.containerSearch != null) {
            this.containerSearch.getConfig(builder);
        }
    }

    public void getConfig(SemanticRulesConfig.Builder builder) {
        if (this.containerSearch != null) {
            this.containerSearch.getConfig(builder);
        }
    }

    public void getConfig(QueryProfilesConfig.Builder builder) {
        if (this.containerSearch != null) {
            this.containerSearch.getConfig(builder);
        }
    }

    public void getConfig(SchemamappingConfig.Builder builder) {
        if (this.containerDocproc != null) {
            this.containerDocproc.getConfig(builder);
        }
    }

    public void getConfig(IndexInfoConfig.Builder builder) {
        if (this.containerSearch != null) {
            this.containerSearch.getConfig(builder);
        }
    }

    public void initialize(Map<String, AbstractSearchCluster> clusterMap) {
        if (this.containerSearch != null) {
            this.containerSearch.connectSearchClusters(clusterMap);
        }
    }

    public void addDefaultSearchAccessLog() {
        this.addComponent(new AccessLogComponent(AccessLogComponent.AccessLogType.jsonAccessLog, this.getName(), this.isHostedVespa));
    }

    public void getConfig(IlscriptsConfig.Builder builder) {
        ArrayList<AbstractSearchCluster> searchClusters = new ArrayList<AbstractSearchCluster>();
        searchClusters.addAll(Content.getSearchClusters(this.getRoot().configModelRepo()));
        for (AbstractSearchCluster searchCluster : searchClusters) {
            searchCluster.getConfig(builder);
        }
    }

    public void getConfig(ClusterInfoConfig.Builder builder) {
        builder.clusterId(this.name);
        builder.nodeCount(this.containers.size());
        for (Service service : this.getDescendantServices()) {
            builder.services.add(new ClusterInfoConfig.Services.Builder().index(Integer.parseInt(service.getServicePropertyString("index", "99999"))).hostname(service.getHostName()).ports(this.getPorts(service)));
        }
    }

    public void getConfig(ConfigserverConfig.Builder builder) {
        builder.system(this.zone.system().value());
        builder.environment(this.zone.environment().value());
        builder.region(this.zone.region().value());
    }

    private List<ClusterInfoConfig.Services.Ports.Builder> getPorts(Service service) {
        ArrayList<ClusterInfoConfig.Services.Ports.Builder> builders = new ArrayList<ClusterInfoConfig.Services.Ports.Builder>();
        PortsMeta portsMeta = service.getPortsMeta();
        for (int i = 0; i < portsMeta.getNumPorts(); ++i) {
            builders.add(new ClusterInfoConfig.Services.Ports.Builder().number(service.getRelativePort(i)).tags(ApplicationConfigProducerRoot.getPortTags(portsMeta, i)));
        }
        return builders;
    }

    public boolean isHostedVespa() {
        return this.isHostedVespa;
    }

    public void getConfig(RoutingProviderConfig.Builder builder) {
        builder.enabled(this.isHostedVespa);
    }

    public Map<String, String> concreteDocumentTypes() {
        return this.concreteDocumentTypes;
    }

    public List<String> serviceAliases() {
        return this.serviceAliases;
    }

    public List<String> endpointAliases() {
        return this.endpointAliases;
    }

    public void setHostClusterId(String clusterId) {
        this.hostClusterId = clusterId;
    }

    public Optional<String> getHostClusterId() {
        return Optional.ofNullable(this.hostClusterId);
    }

    public void setJvmGCOptions(String opts) {
        this.jvmGCOptions = opts;
    }

    public void setEnvironmentVars(String environmentVars) {
        this.environmentVars = environmentVars;
    }

    public Optional<String> getJvmGCOptions() {
        return Optional.ofNullable(this.jvmGCOptions);
    }

    public final void setRpcServerEnabled(boolean rpcServerEnabled) {
        this.rpcServerEnabled = rpcServerEnabled;
    }

    boolean rpcServerEnabled() {
        return this.rpcServerEnabled;
    }

    boolean httpServerEnabled() {
        return this.httpServerEnabled;
    }

    public void setHttpServerEnabled(boolean httpServerEnabled) {
        this.httpServerEnabled = httpServerEnabled;
    }

    public String toString() {
        return "container cluster '" + this.getName() + "'";
    }

    protected abstract boolean messageBusEnabled();
}

