/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.derived;

import com.yahoo.searchdefinition.Search;
import com.yahoo.searchdefinition.derived.Derived;
import com.yahoo.searchdefinition.derived.FieldResultTransform;
import com.yahoo.searchdefinition.document.ImmutableSDField;
import com.yahoo.vespa.config.search.SummarymapConfig;
import com.yahoo.vespa.documentmodel.DocumentSummary;
import com.yahoo.vespa.documentmodel.SummaryField;
import com.yahoo.vespa.documentmodel.SummaryTransform;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class SummaryMap
extends Derived
implements SummarymapConfig.Producer {
    private Map<String, FieldResultTransform> resultTransforms = new LinkedHashMap<String, FieldResultTransform>();

    SummaryMap(Search search) {
        this.derive(search);
    }

    @Override
    protected void derive(Search search) {
        for (DocumentSummary documentSummary : search.getSummaries().values()) {
            this.derive(documentSummary);
        }
        super.derive(search);
    }

    @Override
    protected void derive(ImmutableSDField field, Search search) {
    }

    private void derive(DocumentSummary documentSummary) {
        for (SummaryField summaryField : documentSummary.getSummaryFields()) {
            if (summaryField.getTransform() == SummaryTransform.NONE) continue;
            if (summaryField.getTransform() == SummaryTransform.ATTRIBUTE || summaryField.getTransform() == SummaryTransform.DISTANCE || summaryField.getTransform() == SummaryTransform.GEOPOS || summaryField.getTransform() == SummaryTransform.POSITIONS || summaryField.getTransform() == SummaryTransform.MATCHED_ELEMENTS_FILTER || summaryField.getTransform() == SummaryTransform.MATCHED_ATTRIBUTE_ELEMENTS_FILTER) {
                this.resultTransforms.put(summaryField.getName(), new FieldResultTransform(summaryField.getName(), summaryField.getTransform(), summaryField.getSingleSource()));
                continue;
            }
            this.resultTransforms.put(summaryField.getName(), new FieldResultTransform(summaryField.getName(), summaryField.getTransform(), summaryField.getName()));
        }
    }

    public Iterator resultTransformIterator() {
        return Collections.unmodifiableCollection(this.resultTransforms.values()).iterator();
    }

    @Override
    protected String getDerivedName() {
        return "summarymap";
    }

    private String getCommand(SummaryTransform transform) {
        if (transform.equals((Object)SummaryTransform.DISTANCE)) {
            return "absdist";
        }
        if (transform.isDynamic()) {
            return "dynamicteaser";
        }
        return transform.getName();
    }

    public static boolean isDynamicCommand(String commandName) {
        return commandName.equals("dynamicteaser") || commandName.equals(SummaryTransform.MATCHED_ELEMENTS_FILTER.getName()) || commandName.equals(SummaryTransform.MATCHED_ATTRIBUTE_ELEMENTS_FILTER.getName());
    }

    public void getConfig(SummarymapConfig.Builder builder) {
        builder.defaultoutputclass(-1);
        for (FieldResultTransform frt : this.resultTransforms.values()) {
            SummarymapConfig.Override.Builder oB = new SummarymapConfig.Override.Builder().field(frt.getFieldName()).command(this.getCommand(frt.getTransform()));
            if (frt.getTransform().isDynamic() || frt.getTransform().equals((Object)SummaryTransform.ATTRIBUTE) || frt.getTransform().equals((Object)SummaryTransform.DISTANCE) || frt.getTransform().equals((Object)SummaryTransform.GEOPOS) || frt.getTransform().equals((Object)SummaryTransform.POSITIONS) || frt.getTransform().equals((Object)SummaryTransform.TEXTEXTRACTOR) || frt.getTransform().equals((Object)SummaryTransform.MATCHED_ELEMENTS_FILTER) || frt.getTransform().equals((Object)SummaryTransform.MATCHED_ATTRIBUTE_ELEMENTS_FILTER)) {
                oB.arguments(frt.getArgument());
            } else {
                oB.arguments("");
            }
            builder.override(oB);
        }
    }
}

