/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.model.test;

import com.yahoo.config.ConfigInstance;
import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.model.ConfigModelContext;
import com.yahoo.config.model.ConfigModelRepo;
import com.yahoo.config.model.api.ConfigServerSpec;
import com.yahoo.config.model.api.HostProvisioner;
import com.yahoo.config.model.builder.xml.XmlHelper;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.config.model.producer.AbstractConfigProducerRoot;
import com.yahoo.config.model.test.MockApplicationPackage;
import com.yahoo.text.XML;
import com.yahoo.vespa.model.ConfigProducer;
import com.yahoo.vespa.model.HostSystem;
import com.yahoo.vespa.model.admin.Admin;
import com.yahoo.vespa.model.builder.xml.dom.DomAdminV2Builder;
import com.yahoo.vespa.model.filedistribution.FileDistributionConfigProducer;
import com.yahoo.vespa.model.filedistribution.FileDistributor;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class MockRoot
extends AbstractConfigProducerRoot {
    private static final long serialVersionUID = 1L;
    private HostSystem hostSystem;
    private final DeployState deployState;
    private FileDistributor fileDistributor;
    private Admin admin;

    public MockRoot() {
        this("");
    }

    public MockRoot(String rootConfigId) {
        this(rootConfigId, new MockApplicationPackage.Builder().build());
    }

    public MockRoot(String rootConfigId, ApplicationPackage applicationPackage) {
        this(rootConfigId, new DeployState.Builder().applicationPackage(applicationPackage).build());
    }

    public MockRoot(String rootConfigId, ApplicationPackage applicationPackage, HostProvisioner provisioner) {
        this(rootConfigId, new DeployState.Builder().applicationPackage(applicationPackage).modelHostProvisioner(provisioner).build());
    }

    public MockRoot(String rootConfigId, DeployState deployState) {
        super(rootConfigId);
        this.hostSystem = new HostSystem(this, "hostsystem", deployState.getProvisioner(), deployState.getDeployLogger());
        this.deployState = deployState;
        this.fileDistributor = new FileDistributor(deployState.getFileRegistry(), List.of(), deployState.isHosted());
    }

    @Override
    public FileDistributionConfigProducer getFileDistributionConfigProducer() {
        return null;
    }

    @Override
    public ConfigModelRepo configModelRepo() {
        return new ConfigModelRepo();
    }

    @Override
    public Set<String> getConfigIds() {
        return Collections.unmodifiableSet(this.id2producer.keySet());
    }

    @Override
    public ConfigInstance.Builder getConfig(ConfigInstance.Builder builder, String configId) {
        ConfigProducer cp = (ConfigProducer)this.id2producer.get(configId);
        if (cp == null) {
            return null;
        }
        cp.cascadeConfig(builder);
        cp.addUserConfig(builder);
        return builder;
    }

    public <T extends ConfigInstance> T getConfig(Class<T> configClass, String configId) {
        try {
            ConfigInstance.Builder builder = this.getConfig(MockRoot.getBuilder(configClass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]), configId);
            return (T)((ConfigInstance)configClass.getConstructor(builder.getClass()).newInstance(builder));
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public ConfigProducer getProducer(String configId) {
        return (ConfigProducer)this.id2producer.get(configId);
    }

    public static <T extends ConfigInstance> Class<? extends ConfigInstance.Builder> getBuilder(Class<T> configClass) {
        for (Class<?> memberClass : configClass.getClasses()) {
            if (!memberClass.getSimpleName().equals("Builder")) continue;
            return memberClass;
        }
        throw new RuntimeException("Missing builder");
    }

    public DeployState getDeployState() {
        return this.deployState;
    }

    @Override
    public FileDistributor getFileDistributor() {
        return this.fileDistributor;
    }

    @Override
    public HostSystem hostSystem() {
        return this.hostSystem;
    }

    @Override
    public void addDescendant(String configId, AbstractConfigProducer descendant) {
        if (this.id2producer.containsKey(configId)) {
            throw new RuntimeException("Config ID '" + configId + "' cannot be reserved by an instance of class '" + descendant.getClass().getName() + "' since it is already used by an instance of class '" + ((ConfigProducer)this.id2producer.get(configId)).getClass().getName() + "'");
        }
        this.id2producer.put(configId, descendant);
    }

    @Override
    public void addChild(AbstractConfigProducer abstractConfigProducer) {
        super.addChild(abstractConfigProducer);
    }

    public final void setAdmin(String xml) {
        String servicesXml = "<?xml version='1.0' encoding='utf-8' ?><services>" + xml + "</services>";
        try {
            Document doc = XmlHelper.getDocumentBuilder().parse(new InputSource(new StringReader(servicesXml)));
            this.setAdmin((Admin)new DomAdminV2Builder(ConfigModelContext.ApplicationType.DEFAULT, this.deployState.getFileRegistry(), false, new ArrayList<ConfigServerSpec>()).build(this.deployState, this, (Element)XML.getChildren((Element)doc.getDocumentElement(), (String)"admin").get(0)));
        }
        catch (IOException | SAXException e) {
            throw new RuntimeException(e);
        }
    }

    public final void setAdmin(Admin admin) {
        this.admin = admin;
    }

    @Override
    public final Admin getAdmin() {
        return this.admin;
    }

    public DeployLogger deployLogger() {
        return this.deployState.getDeployLogger();
    }
}

