/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.builder.xml.dom;

import com.yahoo.text.XML;
import com.yahoo.vespa.model.clients.Clients;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DomV20ClientsBuilder {
    private final Clients clients;

    DomV20ClientsBuilder(Clients clients, String version) {
        if (!version.equals("2.0")) {
            throw new IllegalArgumentException("Version '" + version + "' of 'clients' not supported.");
        }
        this.clients = clients;
    }

    public void build(Element spec) {
        NodeList children = spec.getElementsByTagName("load-types");
        for (int i = 0; i < children.getLength(); ++i) {
            this.createLoadTypes((Element)children.item(i), this.clients);
        }
    }

    private void createLoadTypes(Element element, Clients clients) {
        for (Element e : XML.getChildren((Element)element, (String)"type")) {
            String priority = e.getAttribute("default-priority");
            clients.getLoadTypes().addType(e.getAttribute("name"), priority.length() > 0 ? priority : null);
        }
    }
}

