/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.builder.xml.dom;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.container.bundle.BundleInstantiationSpecification;
import com.yahoo.osgi.provider.model.ComponentModel;
import com.yahoo.text.XML;
import com.yahoo.vespa.model.builder.xml.dom.DomComponentBuilder;
import com.yahoo.vespa.model.builder.xml.dom.VespaDomBuilder;
import com.yahoo.vespa.model.container.ApplicationContainerCluster;
import com.yahoo.vespa.model.container.component.Component;
import com.yahoo.vespa.model.container.component.Handler;
import com.yahoo.vespa.model.container.xml.BundleInstantiationSpecificationBuilder;
import java.util.Set;
import java.util.logging.Level;
import org.w3c.dom.Element;

public class DomHandlerBuilder
extends VespaDomBuilder.DomConfigProducerBuilder<Handler> {
    private static final Set<String> reservedBindings = Set.of("http://*/metrics/v2", "http://*/metrics/v2/*", "http://*/state/v1", "http://*/state/v1/*", "http://*/status.html");
    private final ApplicationContainerCluster cluster;

    public DomHandlerBuilder(ApplicationContainerCluster cluster) {
        this.cluster = cluster;
    }

    @Override
    protected Handler doBuild(DeployState deployState, AbstractConfigProducer parent, Element handlerElement) {
        Handler<Component<?, ?>> handler = this.createHandler(handlerElement);
        for (Element binding : XML.getChildren((Element)handlerElement, (String)"binding")) {
            this.addServerBinding(handler, XML.getValue((Element)binding), deployState.getDeployLogger());
        }
        for (Element clientBinding : XML.getChildren((Element)handlerElement, (String)"clientBinding")) {
            handler.addClientBindings(XML.getValue((Element)clientBinding));
        }
        DomComponentBuilder.addChildren(deployState, parent, handlerElement, handler);
        return handler;
    }

    Handler<? super Component<?, ?>> createHandler(Element handlerElement) {
        BundleInstantiationSpecification bundleSpec = BundleInstantiationSpecificationBuilder.build(handlerElement);
        return new Handler(new ComponentModel(bundleSpec));
    }

    private void addServerBinding(Handler<? super Component<?, ?>> handler, String binding, DeployLogger log) {
        this.throwIfBindingIsReserved(binding, handler);
        handler.addServerBindings(binding);
        this.removeExistingServerBinding(binding, handler, log);
    }

    private void throwIfBindingIsReserved(String binding, Handler<?> newHandler) {
        for (String reserved : reservedBindings) {
            if (!binding.equals(reserved)) continue;
            throw new IllegalArgumentException("Binding '" + binding + "' is a reserved Vespa binding and cannot be used by handler: " + newHandler.getComponentId());
        }
    }

    private void removeExistingServerBinding(String binding, Handler<?> newHandler, DeployLogger log) {
        for (Handler<?> handler : this.cluster.getHandlers()) {
            if (!handler.getServerBindings().contains(binding)) continue;
            handler.removeServerBinding(binding);
            log.log(Level.INFO, "Binding '" + binding + "' was already in use by handler '" + handler.getComponentId() + "', but will now be taken over by handler: " + newHandler.getComponentId());
        }
    }
}

