/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model;

import com.yahoo.config.provision.NetworkPorts;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PortFinder {
    private static final Logger log = Logger.getLogger(PortFinder.class.getName());
    private final Map<String, NetworkPorts.Allocation> byKeys = new HashMap<String, NetworkPorts.Allocation>();
    private final Map<Integer, NetworkPorts.Allocation> byPorts = new TreeMap<Integer, NetworkPorts.Allocation>();

    public void use(NetworkPorts.Allocation allocation) {
        NetworkPorts.Allocation toRemove;
        String key = allocation.key();
        if (this.byKeys.containsKey(key)) {
            if (this.byKeys.get((Object)key).port == allocation.port) {
                return;
            }
            toRemove = this.byKeys.remove(key);
            this.byPorts.remove(toRemove.port);
        }
        if (this.byPorts.containsKey(allocation.port)) {
            toRemove = this.byPorts.remove(allocation.port);
            this.byKeys.remove(toRemove.key());
        }
        this.byPorts.put(allocation.port, allocation);
        this.byKeys.put(key, allocation);
    }

    public int findPort(NetworkPorts.Allocation request, String host) {
        String key = request.key();
        if (this.byKeys.containsKey(key)) {
            int port = this.byKeys.get((Object)key).port;
            log.log(Level.FINE, "Re-using port " + port + " for allocation " + request + " on " + host);
            return port;
        }
        int port = request.port;
        while (this.byPorts.containsKey(port)) {
            ++port;
        }
        return port;
    }

    public boolean isFree(int port) {
        return !this.byPorts.containsKey(port);
    }

    public PortFinder(Collection<NetworkPorts.Allocation> allocations) {
        for (NetworkPorts.Allocation a : allocations) {
            this.use(a);
        }
    }

    public Collection<NetworkPorts.Allocation> allocations() {
        return this.byPorts.values();
    }
}

