/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.http;

import com.yahoo.component.ComponentId;
import com.yahoo.component.ComponentSpecification;
import com.yahoo.container.bundle.BundleInstantiationSpecification;
import com.yahoo.jdisc.http.ConnectorConfig;
import com.yahoo.osgi.provider.model.ComponentModel;
import com.yahoo.vespa.model.container.component.SimpleComponent;
import com.yahoo.vespa.model.container.http.ssl.DefaultSslProvider;

public class ConnectorFactory
extends SimpleComponent
implements ConnectorConfig.Producer {
    private final String name;
    private final int listenPort;
    private final SimpleComponent sslProviderComponent;

    public ConnectorFactory(String name, int listenPort) {
        this(name, listenPort, new DefaultSslProvider(name));
    }

    public ConnectorFactory(String name, int listenPort, SimpleComponent sslProviderComponent) {
        super(new ComponentModel(new BundleInstantiationSpecification(new ComponentId(name), ComponentSpecification.fromString((String)"com.yahoo.jdisc.http.server.jetty.ConnectorFactory"), ComponentSpecification.fromString((String)"jdisc_http_service"))));
        this.name = name;
        this.listenPort = listenPort;
        this.sslProviderComponent = sslProviderComponent;
        this.addChild(sslProviderComponent);
        this.inject(sslProviderComponent);
    }

    public void getConfig(ConnectorConfig.Builder connectorBuilder) {
        connectorBuilder.listenPort(this.listenPort);
        connectorBuilder.name(this.name);
        ((ConnectorConfig.Producer)this.sslProviderComponent).getConfig(connectorBuilder);
    }

    public String getName() {
        return this.name;
    }

    public int getListenPort() {
        return this.listenPort;
    }
}

