/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.documentmodel;

import com.yahoo.document.Field;
import com.yahoo.vespa.documentmodel.FieldView;
import com.yahoo.vespa.documentmodel.SummaryField;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class DocumentSummary
extends FieldView {
    private boolean fromDisk = false;
    private DocumentSummary inherited;

    public DocumentSummary(String name) {
        super(name);
    }

    public void setFromDisk(boolean fromDisk) {
        this.fromDisk = fromDisk;
    }

    public boolean isFromDisk() {
        return this.fromDisk;
    }

    public void add(SummaryField summaryField) {
        summaryField.addDestination(this.getName());
        super.add(summaryField);
    }

    public SummaryField getSummaryField(String name) {
        DocumentSummary parent = this.getInherited();
        if (parent != null) {
            return parent.getSummaryField(name);
        }
        return (SummaryField)this.get(name);
    }

    public Collection<SummaryField> getSummaryFields() {
        ArrayList<SummaryField> fields = new ArrayList<SummaryField>(this.getFields().size());
        DocumentSummary parent = this.getInherited();
        if (parent != null) {
            fields.addAll(parent.getSummaryFields());
        }
        for (Field field : this.getFields()) {
            fields.add((SummaryField)field);
        }
        return fields;
    }

    public void purgeImplicits() {
        ArrayList<SummaryField> falseImplicits = new ArrayList<SummaryField>();
        for (SummaryField summaryField : this.getSummaryFields()) {
            if (summaryField.isImplicit()) continue;
            Iterator<SummaryField.Source> j = summaryField.sourceIterator();
            while (j.hasNext()) {
                SummaryField sourceField;
                String sourceName = j.next().getName();
                if (sourceName.equals(summaryField.getName()) || (sourceField = this.getSummaryField(sourceName)) == null || !sourceField.isImplicit()) continue;
                falseImplicits.add(sourceField);
            }
        }
        for (SummaryField field : falseImplicits) {
            this.remove(field.getName());
        }
    }

    public void setInherited(DocumentSummary inherited) {
        this.inherited = inherited;
    }

    public DocumentSummary getInherited() {
        return this.inherited;
    }

    public String toString() {
        return "document summary '" + this.getName() + "'" + (String)(this.inherited == null ? "" : " inheriting from '" + this.inherited.getName() + "'");
    }
}

