/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.document.DataType;
import com.yahoo.searchdefinition.RankProfileRegistry;
import com.yahoo.searchdefinition.Search;
import com.yahoo.searchdefinition.processing.Processor;
import com.yahoo.vespa.documentmodel.DocumentSummary;
import com.yahoo.vespa.documentmodel.SummaryField;
import com.yahoo.vespa.documentmodel.SummaryTransform;
import com.yahoo.vespa.model.container.search.QueryProfiles;

public class ImplicitSummaryFields
extends Processor {
    public ImplicitSummaryFields(Search search, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(search, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process(boolean validate, boolean documentsOnly) {
        for (DocumentSummary docsum : this.search.getSummaries().values()) {
            if (docsum.getInherited() != null) continue;
            this.addField(docsum, new SummaryField("rankfeatures", (DataType)DataType.STRING, SummaryTransform.RANKFEATURES), validate);
            this.addField(docsum, new SummaryField("summaryfeatures", (DataType)DataType.STRING, SummaryTransform.SUMMARYFEATURES), validate);
        }
    }

    private void addField(DocumentSummary docsum, SummaryField field, boolean validate) {
        if (validate && docsum.getSummaryField(field.getName()) != null) {
            throw new IllegalStateException("Summary class '" + docsum.getName() + "' uses reserved field name '" + field.getName() + "'.");
        }
        docsum.add(field);
    }
}

