/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.document;

import com.yahoo.searchdefinition.DocumentReference;
import com.yahoo.searchdefinition.document.ImmutableImportedComplexSDField;
import com.yahoo.searchdefinition.document.ImmutableSDField;
import com.yahoo.searchdefinition.document.ImportedField;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class ImportedComplexField
extends ImportedField {
    private Map<String, ImportedField> nestedFields = new LinkedHashMap<String, ImportedField>(0);

    public ImportedComplexField(String fieldName, DocumentReference reference, ImmutableSDField targetField) {
        super(fieldName, reference, targetField);
    }

    @Override
    public ImmutableSDField asImmutableSDField() {
        return new ImmutableImportedComplexSDField(this);
    }

    public void addNestedField(ImportedField importedField) {
        String prefix = this.fieldName() + ".";
        assert (importedField.fieldName().substring(0, prefix.length()).equals(prefix));
        String suffix = importedField.fieldName().substring(prefix.length());
        this.nestedFields.put(suffix, importedField);
    }

    public Collection<ImportedField> getNestedFields() {
        return this.nestedFields.values();
    }

    public ImportedField getNestedField(String name) {
        if (name.contains(".")) {
            String superFieldName = name.substring(0, name.indexOf("."));
            String subFieldName = name.substring(name.indexOf(".") + 1);
            ImportedField superField = this.nestedFields.get(superFieldName);
            if (superField != null && superField instanceof ImportedComplexField) {
                return ((ImportedComplexField)superField).getNestedField(subFieldName);
            }
            return null;
        }
        return this.nestedFields.get(name);
    }
}

