/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.jersey.xml;

import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.text.XML;
import com.yahoo.vespa.model.builder.xml.dom.VespaDomBuilder;
import com.yahoo.vespa.model.container.jersey.RestApi;
import com.yahoo.vespa.model.container.jersey.RestApiContext;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;

public class RestApiBuilder
extends VespaDomBuilder.DomConfigProducerBuilder<RestApi> {
    @Override
    protected RestApi doBuild(DeployState deployState, AbstractConfigProducer ancestor, Element spec) {
        String bindingPath = spec.getAttribute("path");
        RestApi restApi = new RestApi(bindingPath);
        restApi.setRestApiContext(this.createRestApiContext(ancestor, spec, bindingPath));
        return restApi;
    }

    private RestApiContext createRestApiContext(AbstractConfigProducer ancestor, Element spec, String bindingPath) {
        RestApiContext restApiContext = new RestApiContext(ancestor, bindingPath);
        restApiContext.addBundles(this.getBundles(spec));
        return restApiContext;
    }

    private List<RestApiContext.BundleInfo> getBundles(Element spec) {
        ArrayList<RestApiContext.BundleInfo> bundles = new ArrayList<RestApiContext.BundleInfo>();
        for (Element bundleElement : XML.getChildren((Element)spec, (String)"components")) {
            bundles.add(this.getBundle(bundleElement));
        }
        return bundles;
    }

    private RestApiContext.BundleInfo getBundle(Element bundleElement) {
        RestApiContext.BundleInfo bundle = new RestApiContext.BundleInfo(bundleElement.getAttribute("bundle"));
        for (Element packageElement : XML.getChildren((Element)bundleElement, (String)"package")) {
            bundle.addPackageToScan(XML.getValue((Element)packageElement));
        }
        return bundle;
    }

    private Map<String, String> getInjections(Element spec) {
        LinkedHashMap<String, String> injectForClass = new LinkedHashMap<String, String>();
        for (Element injectElement : XML.getChildren((Element)spec, (String)"inject")) {
            injectForClass.put(injectElement.getAttribute("for-class"), injectElement.getAttribute("component"));
        }
        return injectForClass;
    }
}

