/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.builder.xml.dom;

import com.yahoo.component.Version;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.model.ConfigModelContext;
import com.yahoo.config.provision.Capacity;
import com.yahoo.config.provision.ClusterMembership;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.config.provision.NodeResources;
import com.yahoo.text.XML;
import com.yahoo.vespa.model.HostResource;
import com.yahoo.vespa.model.HostSystem;
import com.yahoo.vespa.model.builder.xml.dom.ModelElement;
import com.yahoo.vespa.model.container.xml.ContainerModelBuilder;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class NodesSpecification {
    private final boolean dedicated;
    private final int count;
    private final int groups;
    private Version version;
    private final boolean required;
    private final boolean canFail;
    private final boolean exclusive;
    private final Optional<NodeResources> resources;
    private final Optional<String> dockerImageRepo;
    private final Optional<String> combinedId;

    private NodesSpecification(boolean dedicated, int count, int groups, Version version, boolean required, boolean canFail, boolean exclusive, Optional<NodeResources> resources, Optional<String> dockerImageRepo, Optional<String> combinedId) {
        this.dedicated = dedicated;
        this.count = count;
        this.groups = groups;
        this.version = version;
        this.required = required;
        this.canFail = canFail;
        this.exclusive = exclusive;
        this.resources = resources;
        this.dockerImageRepo = dockerImageRepo;
        this.combinedId = combinedId;
    }

    private NodesSpecification(boolean dedicated, boolean canFail, Version version, ModelElement nodesElement, Optional<String> combinedId, Optional<String> dockerImageRepo) {
        this(dedicated, nodesElement.integerAttribute("count", 1), nodesElement.integerAttribute("groups", 1), version, nodesElement.booleanAttribute("required", false), canFail, nodesElement.booleanAttribute("exclusive", false), NodesSpecification.getResources(nodesElement), NodesSpecification.dockerImageToUse(nodesElement, dockerImageRepo), combinedId);
    }

    private static Optional<String> findCombinedId(ModelElement nodesElement, ModelElement resolvedElement) {
        if (resolvedElement != nodesElement) {
            return NodesSpecification.containerIdOf(nodesElement);
        }
        return NodesSpecification.containerIdReferencing(nodesElement);
    }

    private static NodesSpecification create(boolean dedicated, boolean canFail, Version version, ModelElement nodesElement, Optional<String> dockerImage) {
        ModelElement resolvedElement = NodesSpecification.resolveElement(nodesElement);
        Optional<String> combinedId = NodesSpecification.findCombinedId(nodesElement, resolvedElement);
        return new NodesSpecification(dedicated, canFail, version, resolvedElement, combinedId, dockerImage);
    }

    public static NodesSpecification from(ModelElement nodesElement, ConfigModelContext context) {
        return NodesSpecification.create(true, !context.getDeployState().getProperties().isBootstrap(), context.getDeployState().getWantedNodeVespaVersion(), nodesElement, context.getDeployState().getWantedDockerImageRepo());
    }

    public static Optional<NodesSpecification> fromParent(ModelElement parentElement, ConfigModelContext context) {
        if (parentElement == null) {
            return Optional.empty();
        }
        ModelElement nodesElement = parentElement.child("nodes");
        if (nodesElement == null) {
            return Optional.empty();
        }
        return Optional.of(NodesSpecification.from(nodesElement, context));
    }

    public static Optional<NodesSpecification> optionalDedicatedFromParent(ModelElement parentElement, ConfigModelContext context) {
        if (parentElement == null) {
            return Optional.empty();
        }
        ModelElement nodesElement = parentElement.child("nodes");
        if (nodesElement == null) {
            return Optional.empty();
        }
        return Optional.of(NodesSpecification.create(nodesElement.booleanAttribute("dedicated", false), !context.getDeployState().getProperties().isBootstrap(), context.getDeployState().getWantedNodeVespaVersion(), nodesElement, context.getDeployState().getWantedDockerImageRepo()));
    }

    public static NodesSpecification nonDedicated(int count, ConfigModelContext context) {
        return new NodesSpecification(false, count, 1, context.getDeployState().getWantedNodeVespaVersion(), false, !context.getDeployState().getProperties().isBootstrap(), false, Optional.empty(), context.getDeployState().getWantedDockerImageRepo(), Optional.empty());
    }

    public static NodesSpecification dedicated(int count, ConfigModelContext context) {
        return new NodesSpecification(true, count, 1, context.getDeployState().getWantedNodeVespaVersion(), false, !context.getDeployState().getProperties().isBootstrap(), false, Optional.empty(), context.getDeployState().getWantedDockerImageRepo(), Optional.empty());
    }

    public boolean isDedicated() {
        return this.dedicated;
    }

    public boolean isExclusive() {
        return this.exclusive;
    }

    public int count() {
        return this.count;
    }

    public int groups() {
        return this.groups;
    }

    public Map<HostResource, ClusterMembership> provision(HostSystem hostSystem, ClusterSpec.Type clusterType, ClusterSpec.Id clusterId, DeployLogger logger) {
        if (this.combinedId.isPresent()) {
            clusterType = ClusterSpec.Type.combined;
        }
        ClusterSpec cluster = ClusterSpec.request((ClusterSpec.Type)clusterType, (ClusterSpec.Id)clusterId).vespaVersion(this.version).exclusive(this.exclusive).combinedId(this.combinedId.map(ClusterSpec.Id::from)).dockerImageRepo(this.dockerImageRepo).build();
        return hostSystem.allocateHosts(cluster, Capacity.fromCount((int)this.count, this.resources, (boolean)this.required, (boolean)this.canFail), this.groups, logger);
    }

    private static Optional<NodeResources> getResources(ModelElement nodesElement) {
        ModelElement resources = nodesElement.child("resources");
        if (resources != null) {
            return Optional.of(new NodeResources(resources.requiredDoubleAttribute("vcpu"), NodesSpecification.parseGbAmount(resources.requiredStringAttribute("memory"), "B"), NodesSpecification.parseGbAmount(resources.requiredStringAttribute("disk"), "B"), Optional.ofNullable(resources.stringAttribute("bandwidth")).map(b -> NodesSpecification.parseGbAmount(b, "BPS")).orElse(0.3).doubleValue(), NodesSpecification.parseOptionalDiskSpeed(resources.stringAttribute("disk-speed")), NodesSpecification.parseOptionalStorageType(resources.stringAttribute("storage-type"))));
        }
        if (nodesElement.stringAttribute("flavor") != null) {
            return Optional.of(NodeResources.fromLegacyName((String)nodesElement.stringAttribute("flavor")));
        }
        return Optional.empty();
    }

    private static double parseGbAmount(String byteAmount, String unit) {
        byteAmount = byteAmount.strip();
        if ((byteAmount = byteAmount.toUpperCase()).endsWith(unit)) {
            byteAmount = byteAmount.substring(0, byteAmount.length() - unit.length());
        }
        double multiplier = Math.pow(1000.0, -3.0);
        if (byteAmount.endsWith("K")) {
            multiplier = Math.pow(1000.0, -2.0);
        } else if (byteAmount.endsWith("M")) {
            multiplier = Math.pow(1000.0, -1.0);
        } else if (byteAmount.endsWith("G")) {
            multiplier = 1.0;
        } else if (byteAmount.endsWith("T")) {
            multiplier = 1000.0;
        } else if (byteAmount.endsWith("P")) {
            multiplier = Math.pow(1000.0, 2.0);
        } else if (byteAmount.endsWith("E")) {
            multiplier = Math.pow(1000.0, 3.0);
        } else if (byteAmount.endsWith("Z")) {
            multiplier = Math.pow(1000.0, 4.0);
        } else if (byteAmount.endsWith("Y")) {
            multiplier = Math.pow(1000.0, 5.0);
        }
        byteAmount = byteAmount.substring(0, byteAmount.length() - 1).strip();
        try {
            return Double.parseDouble(byteAmount) * multiplier;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid byte amount '" + byteAmount + "': Must be a floating point number optionally followed by k, M, G, T, P, E, Z or Y");
        }
    }

    private static NodeResources.DiskSpeed parseOptionalDiskSpeed(String diskSpeedString) {
        if (diskSpeedString == null) {
            return NodeResources.DiskSpeed.getDefault();
        }
        switch (diskSpeedString) {
            case "fast": {
                return NodeResources.DiskSpeed.fast;
            }
            case "slow": {
                return NodeResources.DiskSpeed.slow;
            }
            case "any": {
                return NodeResources.DiskSpeed.any;
            }
        }
        throw new IllegalArgumentException("Illegal disk-speed value '" + diskSpeedString + "': Legal values are 'fast', 'slow' and 'any')");
    }

    private static NodeResources.StorageType parseOptionalStorageType(String storageTypeString) {
        if (storageTypeString == null) {
            return NodeResources.StorageType.getDefault();
        }
        switch (storageTypeString) {
            case "remote": {
                return NodeResources.StorageType.remote;
            }
            case "local": {
                return NodeResources.StorageType.local;
            }
            case "any": {
                return NodeResources.StorageType.any;
            }
        }
        throw new IllegalArgumentException("Illegal storage-type value '" + storageTypeString + "': Legal values are 'remote', 'local' and 'any')");
    }

    private static ModelElement resolveElement(ModelElement nodesElement) {
        Element element = nodesElement.getXml();
        String referenceId = element.getAttribute("of");
        if (referenceId.isEmpty()) {
            return nodesElement;
        }
        Element services = NodesSpecification.findParentByTag("services", element).orElseThrow(() -> NodesSpecification.clusterReferenceNotFoundException(referenceId));
        Element referencedService = NodesSpecification.findChildById(services, referenceId).orElseThrow(() -> NodesSpecification.clusterReferenceNotFoundException(referenceId));
        if (!referencedService.getTagName().equals("content")) {
            throw new IllegalArgumentException("service '" + referenceId + "' is not a content service");
        }
        Element referencedNodesElement = XML.getChild((Element)referencedService, (String)"nodes");
        if (referencedNodesElement == null) {
            throw new IllegalArgumentException("expected reference to service '" + referenceId + "' to supply nodes, but that service has no <nodes> element");
        }
        return new ModelElement(referencedNodesElement);
    }

    private static Optional<String> containerIdOf(ModelElement nodesElement) {
        Element element = nodesElement.getXml();
        for (String containerTag : List.of("container", "jdisc")) {
            Optional<Element> container = NodesSpecification.findParentByTag(containerTag, element);
            if (container.isEmpty()) continue;
            return container.map(el -> el.getAttribute("id"));
        }
        return Optional.empty();
    }

    private static Optional<String> containerIdReferencing(ModelElement nodesElement) {
        Element element = nodesElement.getXml();
        Optional<Element> services = NodesSpecification.findParentByTag("services", element);
        if (services.isEmpty()) {
            return Optional.empty();
        }
        Optional<Element> content = NodesSpecification.findParentByTag("content", element);
        if (content.isEmpty()) {
            return Optional.empty();
        }
        String contentClusterId = content.get().getAttribute("id");
        if (contentClusterId.isEmpty()) {
            return Optional.empty();
        }
        for (Element rootChild : XML.getChildren((Element)services.get())) {
            Element nodes;
            if (!ContainerModelBuilder.isContainerTag(rootChild) || (nodes = XML.getChild((Element)rootChild, (String)"nodes")) == null || !contentClusterId.equals(nodes.getAttribute("of"))) continue;
            return Optional.of(rootChild.getAttribute("id"));
        }
        return Optional.empty();
    }

    private static Optional<Element> findChildById(Element parent, String id) {
        for (Element child : XML.getChildren((Element)parent)) {
            if (!id.equals(child.getAttribute("id"))) continue;
            return Optional.of(child);
        }
        return Optional.empty();
    }

    private static Optional<Element> findParentByTag(String tag, Element element) {
        Node parent = element.getParentNode();
        if (parent == null) {
            return Optional.empty();
        }
        if (!(parent instanceof Element)) {
            return Optional.empty();
        }
        Element parentElement = (Element)parent;
        if (parentElement.getTagName().equals(tag)) {
            return Optional.of(parentElement);
        }
        return NodesSpecification.findParentByTag(tag, parentElement);
    }

    private static IllegalArgumentException clusterReferenceNotFoundException(String referenceId) {
        return new IllegalArgumentException("referenced service '" + referenceId + "' is not defined");
    }

    private static Optional<String> dockerImageToUse(ModelElement nodesElement, Optional<String> dockerImage) {
        String dockerImageFromElement = nodesElement.stringAttribute("docker-image");
        return dockerImageFromElement == null ? dockerImage : Optional.of(dockerImageFromElement);
    }

    public String toString() {
        return "specification of " + this.count + (this.dedicated ? " dedicated " : " ") + "nodes" + this.resources.map(nodeResources -> " with resources " + nodeResources).orElse("") + (String)(this.groups > 1 ? " in " + this.groups + " groups" : "");
    }
}

