/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.http;

import com.yahoo.component.ComponentId;
import com.yahoo.component.ComponentSpecification;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.vespa.model.container.ApplicationContainerCluster;
import com.yahoo.vespa.model.container.ContainerCluster;
import com.yahoo.vespa.model.container.component.Handler;
import com.yahoo.vespa.model.container.component.Servlet;
import com.yahoo.vespa.model.container.http.Binding;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class AccessControl {
    public static final ComponentId ACCESS_CONTROL_CHAIN_ID = ComponentId.fromString((String)"access-control-chain");
    public static final List<String> UNPROTECTED_HANDLERS = List.of("com.yahoo.container.handler.VipStatusHandler", "com.yahoo.container.handler.observability.ApplicationStatusHandler", ContainerCluster.BINDINGS_OVERVIEW_HANDLER_CLASS, "com.yahoo.container.jdisc.state.StateHandler", ContainerCluster.LOG_HANDLER_CLASS, ApplicationContainerCluster.METRICS_V2_HANDLER_CLASS);
    public final String domain;
    public final String applicationId;
    public final boolean readEnabled;
    public final boolean writeEnabled;
    public final Optional<String> vespaDomain;
    private final Set<String> excludedBindings;
    private final Collection<Handler<?>> handlers;
    private final Collection<Servlet> servlets;
    private final DeployLogger logger;

    private AccessControl(String domain, String applicationId, boolean writeEnabled, boolean readEnabled, Set<String> excludedBindings, Optional<String> vespaDomain, Collection<Servlet> servlets, Collection<Handler<?>> handlers, DeployLogger logger) {
        this.domain = domain;
        this.applicationId = applicationId;
        this.readEnabled = readEnabled;
        this.writeEnabled = writeEnabled;
        this.excludedBindings = Collections.unmodifiableSet(excludedBindings);
        this.vespaDomain = vespaDomain;
        this.handlers = handlers;
        this.servlets = servlets;
        this.logger = logger;
    }

    public List<Binding> getBindings() {
        return Stream.concat(this.getHandlerBindings(), this.getServletBindings()).collect(Collectors.toCollection(ArrayList::new));
    }

    private Stream<Binding> getHandlerBindings() {
        return this.handlers.stream().filter(this::shouldHandlerBeProtected).flatMap(handler -> handler.getServerBindings().stream()).map(binding -> AccessControl.accessControlBinding(binding, this.logger));
    }

    private Stream<Binding> getServletBindings() {
        return this.servlets.stream().filter(this::shouldServletBeProtected).flatMap(AccessControl::servletBindings).map(binding -> AccessControl.accessControlBinding(binding, this.logger));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean shouldHandlerBeProtected(Handler<?> handler) {
        if (AccessControl.isBuiltinGetOnly(handler)) return false;
        if (!handler.getServerBindings().stream().noneMatch(this.excludedBindings::contains)) return false;
        return true;
    }

    public static boolean isBuiltinGetOnly(Handler<?> handler) {
        return UNPROTECTED_HANDLERS.contains(handler.getClassId().getName());
    }

    private boolean shouldServletBeProtected(Servlet servlet) {
        return AccessControl.servletBindings(servlet).noneMatch(this.excludedBindings::contains);
    }

    private static Binding accessControlBinding(String binding, DeployLogger logger) {
        return Binding.create(new ComponentSpecification(ACCESS_CONTROL_CHAIN_ID.stringValue()), binding, logger);
    }

    private static Stream<String> servletBindings(Servlet servlet) {
        return Stream.of("http://*/").map(protocol -> protocol + servlet.bindingPath);
    }

    public static final class Builder {
        private String domain;
        private String applicationId;
        private Optional<String> vespaDomain = Optional.empty();
        private boolean readEnabled = false;
        private boolean writeEnabled = true;
        private final Set<String> excludeBindings = new LinkedHashSet<String>();
        private Collection<Handler<?>> handlers = Collections.emptyList();
        private Collection<Servlet> servlets = Collections.emptyList();
        private final DeployLogger logger;

        public Builder(String domain, String applicationId, DeployLogger logger) {
            this.domain = domain;
            this.applicationId = applicationId;
            this.logger = logger;
        }

        public Builder readEnabled(boolean readEnabled) {
            this.readEnabled = readEnabled;
            return this;
        }

        public Builder writeEnabled(boolean writeEnalbed) {
            this.writeEnabled = writeEnalbed;
            return this;
        }

        public Builder excludeBinding(String binding) {
            this.excludeBindings.add(binding);
            return this;
        }

        public Builder vespaDomain(String vespaDomain) {
            this.vespaDomain = Optional.ofNullable(vespaDomain);
            return this;
        }

        public Builder setHandlers(Collection<Handler<?>> handlers) {
            this.handlers = handlers;
            return this;
        }

        public Builder setServlets(Collection<Servlet> servlets) {
            this.servlets = servlets;
            return this;
        }

        public AccessControl build() {
            return new AccessControl(this.domain, this.applicationId, this.writeEnabled, this.readEnabled, this.excludeBindings, this.vespaDomain, this.servlets, this.handlers, this.logger);
        }
    }
}

