/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.admin.metricsproxy;

import ai.vespa.metricsproxy.core.ConsumersConfig;
import ai.vespa.metricsproxy.core.MetricsConsumers;
import ai.vespa.metricsproxy.core.MetricsManager;
import ai.vespa.metricsproxy.core.MonitoringConfig;
import ai.vespa.metricsproxy.core.VespaMetrics;
import ai.vespa.metricsproxy.http.application.ApplicationMetricsHandler;
import ai.vespa.metricsproxy.http.application.ApplicationMetricsRetriever;
import ai.vespa.metricsproxy.http.application.MetricsNodesConfig;
import ai.vespa.metricsproxy.http.metrics.MetricsV1Handler;
import ai.vespa.metricsproxy.http.prometheus.PrometheusHandler;
import ai.vespa.metricsproxy.http.yamas.YamasHandler;
import ai.vespa.metricsproxy.metric.ExternalMetrics;
import ai.vespa.metricsproxy.metric.dimensions.ApplicationDimensions;
import ai.vespa.metricsproxy.metric.dimensions.ApplicationDimensionsConfig;
import ai.vespa.metricsproxy.rpc.RpcServer;
import ai.vespa.metricsproxy.service.ConfigSentinelClient;
import ai.vespa.metricsproxy.service.SystemPollerProvider;
import ai.vespa.metricsproxy.telegraf.Telegraf;
import ai.vespa.metricsproxy.telegraf.TelegrafConfig;
import ai.vespa.metricsproxy.telegraf.TelegrafRegistry;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.config.model.producer.AbstractConfigProducerRoot;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.Zone;
import com.yahoo.container.handler.ThreadpoolConfig;
import com.yahoo.container.jdisc.ThreadedHttpRequestHandler;
import com.yahoo.osgi.provider.model.ComponentModel;
import com.yahoo.vespa.model.VespaModel;
import com.yahoo.vespa.model.admin.Admin;
import com.yahoo.vespa.model.admin.metricsproxy.ConsumersConfigGenerator;
import com.yahoo.vespa.model.admin.metricsproxy.MetricsNodesConfigGenerator;
import com.yahoo.vespa.model.admin.metricsproxy.MetricsProxyContainer;
import com.yahoo.vespa.model.admin.monitoring.CloudWatch;
import com.yahoo.vespa.model.admin.monitoring.DefaultPublicConsumer;
import com.yahoo.vespa.model.admin.monitoring.MetricSet;
import com.yahoo.vespa.model.admin.monitoring.MetricsConsumer;
import com.yahoo.vespa.model.admin.monitoring.Monitoring;
import com.yahoo.vespa.model.admin.monitoring.VespaMetricsConsumer;
import com.yahoo.vespa.model.container.ContainerCluster;
import com.yahoo.vespa.model.container.component.Handler;
import com.yahoo.vespa.model.container.xml.BundleMapper;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;

public class MetricsProxyContainerCluster
extends ContainerCluster<MetricsProxyContainer>
implements ApplicationDimensionsConfig.Producer,
ConsumersConfig.Producer,
MonitoringConfig.Producer,
TelegrafConfig.Producer,
ThreadpoolConfig.Producer,
MetricsNodesConfig.Producer {
    public static final Logger log = Logger.getLogger(MetricsProxyContainerCluster.class.getName());
    private static final String METRICS_PROXY_NAME = "metrics-proxy";
    static final Path METRICS_PROXY_BUNDLE_FILE = BundleMapper.absoluteBundlePath(Paths.get("metrics-proxy" + BundleMapper.JarSuffix.JAR_WITH_DEPS.suffix, new String[0]));
    static final String METRICS_PROXY_BUNDLE_NAME = "com.yahoo.vespa.metrics-proxy";
    private final AbstractConfigProducer<?> parent;
    private final ApplicationId applicationId;

    public MetricsProxyContainerCluster(AbstractConfigProducer<?> parent, String name, DeployState deployState) {
        super(parent, name, name, deployState);
        this.parent = parent;
        this.applicationId = deployState.getProperties().applicationId();
        this.setRpcServerEnabled(true);
        this.addDefaultHandlersExceptStatus();
        this.addPlatformBundle(METRICS_PROXY_BUNDLE_FILE);
        this.addClusterComponents();
    }

    private void addClusterComponents() {
        this.addMetricsProxyComponent(ApplicationDimensions.class);
        this.addMetricsProxyComponent(ConfigSentinelClient.class);
        this.addMetricsProxyComponent(ExternalMetrics.class);
        this.addMetricsProxyComponent(MetricsConsumers.class);
        this.addMetricsProxyComponent(MetricsManager.class);
        this.addMetricsProxyComponent(RpcServer.class);
        this.addMetricsProxyComponent(SystemPollerProvider.class);
        this.addMetricsProxyComponent(VespaMetrics.class);
        this.addHttpHandler(MetricsV1Handler.class, "/metrics/v1");
        this.addHttpHandler(PrometheusHandler.class, "/prometheus/v1");
        this.addHttpHandler(YamasHandler.class, "/yamas/v1");
        this.addHttpHandler(ApplicationMetricsHandler.class, "/applicationmetrics/v1");
        this.addMetricsProxyComponent(ApplicationMetricsRetriever.class);
        this.addTelegrafComponents();
    }

    private void addHttpHandler(Class<? extends ThreadedHttpRequestHandler> clazz, String bindingPath) {
        Handler<AbstractConfigProducer<?>> metricsHandler = MetricsProxyContainerCluster.createMetricsHandler(clazz, bindingPath);
        this.addComponent(metricsHandler);
    }

    static Handler<AbstractConfigProducer<?>> createMetricsHandler(Class<? extends ThreadedHttpRequestHandler> clazz, String bindingPath) {
        Handler metricsHandler = new Handler(new ComponentModel(clazz.getName(), null, METRICS_PROXY_BUNDLE_NAME, null));
        metricsHandler.addServerBindings("http://*" + bindingPath, "http://*" + bindingPath + "/*");
        return metricsHandler;
    }

    private void addTelegrafComponents() {
        this.getAdmin().ifPresent(admin -> {
            if (admin.getUserMetrics().usesExternalMetricSystems()) {
                this.addMetricsProxyComponent(Telegraf.class);
                this.addMetricsProxyComponent(TelegrafRegistry.class);
            }
        });
    }

    @Override
    protected void doPrepare(DeployState deployState) {
    }

    public void getConfig(MetricsNodesConfig.Builder builder) {
        builder.node.addAll(MetricsNodesConfigGenerator.generate(this.getContainers()));
    }

    public void getConfig(MonitoringConfig.Builder builder) {
        this.getSystemName().ifPresent(arg_0 -> ((MonitoringConfig.Builder)builder).systemName(arg_0));
        this.getIntervalMinutes().ifPresent(arg_0 -> ((MonitoringConfig.Builder)builder).intervalMinutes(arg_0));
    }

    public void getConfig(ConsumersConfig.Builder builder) {
        MetricsConsumer amendedVespaConsumer = ConsumersConfigGenerator.addMetrics(VespaMetricsConsumer.getVespaMetricsConsumer(), this.getAdditionalDefaultMetrics().getMetrics());
        builder.consumer.addAll(ConsumersConfigGenerator.generateConsumers(amendedVespaConsumer, this.getUserMetricsConsumers()));
        builder.consumer.add(ConsumersConfigGenerator.toConsumerBuilder(DefaultPublicConsumer.getDefaultPublicConsumer()));
    }

    public void getConfig(ApplicationDimensionsConfig.Builder builder) {
        if (this.isHostedVespa()) {
            builder.dimensions(this.applicationDimensions());
        }
    }

    public void getConfig(TelegrafConfig.Builder builder) {
        builder.isHostedVespa(this.isHostedVespa());
        Map<String, MetricsConsumer> userConsumers = this.getUserMetricsConsumers();
        for (MetricsConsumer consumer : userConsumers.values()) {
            for (CloudWatch cloudWatch : consumer.cloudWatches()) {
                TelegrafConfig.CloudWatch.Builder cloudWatchBuilder = new TelegrafConfig.CloudWatch.Builder();
                cloudWatchBuilder.region(cloudWatch.region()).namespace(cloudWatch.namespace()).consumer(cloudWatch.consumer());
                cloudWatch.hostedAuth().ifPresent(hostedAuth -> cloudWatchBuilder.accessKeyName(hostedAuth.accessKeyName).secretKeyName(hostedAuth.secretKeyName));
                cloudWatch.sharedCredentials().ifPresent(sharedCredentials -> cloudWatchBuilder.profile(sharedCredentials.profile).file(sharedCredentials.file));
                builder.cloudWatch(cloudWatchBuilder);
            }
        }
    }

    public void getConfig(ThreadpoolConfig.Builder builder) {
        builder.maxthreads(10);
    }

    @Override
    protected boolean messageBusEnabled() {
        return false;
    }

    private MetricSet getAdditionalDefaultMetrics() {
        return this.getAdmin().map(Admin::getAdditionalDefaultMetrics).orElse(MetricSet.emptyMetricSet());
    }

    private Map<String, MetricsConsumer> getUserMetricsConsumers() {
        return this.getAdmin().map(admin -> admin.getUserMetrics().getConsumers()).orElse(Collections.emptyMap());
    }

    private Optional<Admin> getAdmin() {
        AbstractConfigProducerRoot r;
        if (this.parent != null && (r = this.parent.getRoot()) instanceof VespaModel) {
            VespaModel model = (VespaModel)r;
            return Optional.ofNullable(model.getAdmin());
        }
        return Optional.empty();
    }

    private Optional<String> getSystemName() {
        Monitoring monitoring = this.getMonitoringService();
        return monitoring != null && !monitoring.getClustername().equals("") ? Optional.of(monitoring.getClustername()) : Optional.empty();
    }

    private Optional<Integer> getIntervalMinutes() {
        Monitoring monitoring = this.getMonitoringService();
        return monitoring != null ? Optional.of(monitoring.getInterval()) : Optional.empty();
    }

    private void addMetricsProxyComponent(Class<?> componentClass) {
        this.addSimpleComponent(componentClass.getName(), null, METRICS_PROXY_BUNDLE_NAME);
    }

    private Map<String, String> applicationDimensions() {
        LinkedHashMap<String, String> dimensions = new LinkedHashMap<String, String>();
        dimensions.put("system", this.getZone().system().value());
        dimensions.put("zone", MetricsProxyContainerCluster.zoneString(this.getZone()));
        dimensions.put("applicationId", MetricsProxyContainerCluster.serializeWithDots(this.applicationId));
        dimensions.put("tenantName", this.applicationId.tenant().value());
        dimensions.put("applicationName", this.applicationId.application().value());
        dimensions.put("instanceName", this.applicationId.instance().value());
        dimensions.put("app", this.applicationId.application().value() + "." + this.applicationId.instance().value());
        return dimensions;
    }

    private static String serializeWithDots(ApplicationId applicationId) {
        return applicationId.serializedForm().replace(':', '.');
    }

    static String zoneString(Zone zone) {
        return zone.environment().value() + "." + zone.region().value();
    }

    static final class AppDimensionNames {
        static final String SYSTEM = "system";
        static final String TENANT = "tenantName";
        static final String APPLICATION = "applicationName";
        static final String INSTANCE = "instanceName";
        static final String LEGACY_APPLICATION = "app";

        AppDimensionNames() {
        }
    }
}

