/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.document;

import java.util.OptionalInt;

public class HnswIndexParams {
    public static final int DEFAULT_MAX_LINKS_PER_NODE = 16;
    public static final int DEFAULT_NEIGHBORS_TO_EXPLORE_AT_INSERT = 200;
    private final OptionalInt maxLinksPerNode;
    private final OptionalInt neighborsToExploreAtInsert;

    public HnswIndexParams() {
        this.maxLinksPerNode = OptionalInt.empty();
        this.neighborsToExploreAtInsert = OptionalInt.empty();
    }

    public HnswIndexParams(OptionalInt maxLinksPerNode, OptionalInt neighborsToExploreAtInsert) {
        this.maxLinksPerNode = maxLinksPerNode;
        this.neighborsToExploreAtInsert = neighborsToExploreAtInsert;
    }

    public HnswIndexParams overrideFrom(HnswIndexParams rhs) {
        return new HnswIndexParams(rhs.maxLinksPerNode.isPresent() ? rhs.maxLinksPerNode : this.maxLinksPerNode, rhs.neighborsToExploreAtInsert.isPresent() ? rhs.neighborsToExploreAtInsert : this.neighborsToExploreAtInsert);
    }

    public int maxLinksPerNode() {
        return this.maxLinksPerNode.orElse(16);
    }

    public int neighborsToExploreAtInsert() {
        return this.neighborsToExploreAtInsert.orElse(200);
    }

    public static class Builder {
        private OptionalInt maxLinksPerNode = OptionalInt.empty();
        private OptionalInt neighborsToExploreAtInsert = OptionalInt.empty();

        public void setMaxLinksPerNode(int value) {
            this.maxLinksPerNode = OptionalInt.of(value);
        }

        public void setNeighborsToExploreAtInsert(int value) {
            this.neighborsToExploreAtInsert = OptionalInt.of(value);
        }

        public HnswIndexParams build() {
            return new HnswIndexParams(this.maxLinksPerNode, this.neighborsToExploreAtInsert);
        }
    }
}

