/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.content.storagecluster;

import com.yahoo.vespa.config.content.StorFilestorConfig;
import com.yahoo.vespa.model.builder.xml.dom.ModelElement;
import com.yahoo.vespa.model.content.cluster.ContentCluster;

public class FileStorProducer
implements StorFilestorConfig.Producer {
    private Integer numThreads;
    private ContentCluster cluster;

    public FileStorProducer(ContentCluster parent, Integer numThreads) {
        this.numThreads = numThreads;
        this.cluster = parent;
    }

    public void getConfig(StorFilestorConfig.Builder builder) {
        if (this.numThreads != null) {
            builder.num_threads(this.numThreads.intValue());
        }
        builder.enable_multibit_split_optimalization(this.cluster.getPersistence().enableMultiLevelSplitting());
    }

    public static class Builder {
        protected FileStorProducer build(ContentCluster parent, ModelElement clusterElem) {
            return new FileStorProducer(parent, this.getThreads(clusterElem));
        }

        private Integer getThreads(ModelElement clusterElem) {
            ModelElement tuning = clusterElem.child("tuning");
            if (tuning == null) {
                return null;
            }
            ModelElement threads = tuning.child("persistence-threads");
            if (threads == null) {
                return null;
            }
            Integer count = threads.integerAttribute("count");
            if (count != null) {
                return count;
            }
            int numThreads = 0;
            for (ModelElement thread : threads.subElements("thread")) {
                count = thread.integerAttribute("count");
                numThreads += count == null ? 1 : count;
            }
            return numThreads;
        }
    }
}

