/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.jersey;

import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.vespa.model.container.jersey.Jersey2Servlet;
import com.yahoo.vespa.model.container.jersey.RestApiContext;

public class RestApi
extends AbstractConfigProducer<AbstractConfigProducer<?>> {
    private final String bindingPath;
    private final Jersey2Servlet jerseyServlet;
    private RestApiContext restApiContext;

    public RestApi(String bindingPath) {
        super(RestApi.idFromPath(bindingPath));
        this.bindingPath = bindingPath;
        this.jerseyServlet = this.createJersey2Servlet(this.bindingPath);
        this.addChild(this.jerseyServlet);
    }

    public static String idFromPath(String path) {
        return path.replaceAll("/", "|");
    }

    private Jersey2Servlet createJersey2Servlet(String bindingPath) {
        return new Jersey2Servlet(bindingPath);
    }

    public String getBindingPath() {
        return this.bindingPath;
    }

    public void setRestApiContext(RestApiContext restApiContext) {
        this.restApiContext = restApiContext;
        this.addChild(restApiContext);
        this.jerseyServlet.inject(restApiContext);
    }

    public RestApiContext getContext() {
        return this.restApiContext;
    }

    public Jersey2Servlet getJersey2Servlet() {
        return this.jerseyServlet;
    }

    public void prepare() {
        this.restApiContext.prepare();
    }
}

