/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.document.CollectionDataType;
import com.yahoo.document.TensorDataType;
import com.yahoo.searchdefinition.Index;
import com.yahoo.searchdefinition.RankProfileRegistry;
import com.yahoo.searchdefinition.Search;
import com.yahoo.searchdefinition.document.Attribute;
import com.yahoo.searchdefinition.document.HnswIndexParams;
import com.yahoo.searchdefinition.document.ImmutableSDField;
import com.yahoo.searchdefinition.document.SDField;
import com.yahoo.searchdefinition.processing.Processor;
import com.yahoo.tensor.TensorType;
import com.yahoo.vespa.model.container.search.QueryProfiles;

public class TensorFieldProcessor
extends Processor {
    public TensorFieldProcessor(Search search, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(search, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process(boolean validate, boolean documentsOnly) {
        for (SDField field : this.search.allConcreteFields()) {
            if (field.getDataType() instanceof TensorDataType) {
                if (validate) {
                    this.validateIndexingScripsForTensorField(field);
                    this.validateAttributeSettingForTensorField(field);
                }
                this.processIndexSettingsForTensorField(field, validate);
                continue;
            }
            if (!(field.getDataType() instanceof CollectionDataType) || !validate) continue;
            this.validateDataTypeForCollectionField(field);
        }
    }

    private void validateIndexingScripsForTensorField(SDField field) {
        if (field.doesIndexing() && !this.isTensorTypeThatSupportsHnswIndex(field)) {
            this.fail(this.search, field, "A tensor of type '" + this.tensorTypeToString(field) + "' does not support having an 'index'. Currently, only tensors with 1 indexed dimension supports that.");
        }
    }

    private boolean isTensorTypeThatSupportsHnswIndex(ImmutableSDField field) {
        TensorType type = ((TensorDataType)field.getDataType()).getTensorType();
        return type.dimensions().size() == 1 && ((TensorType.Dimension)type.dimensions().get(0)).isIndexed();
    }

    private String tensorTypeToString(ImmutableSDField field) {
        return ((TensorDataType)field.getDataType()).getTensorType().toString();
    }

    private void validateAttributeSettingForTensorField(SDField field) {
        Attribute attribute;
        if (field.doesAttributing() && (attribute = field.getAttributes().get(field.getName())) != null && attribute.isFastSearch()) {
            this.fail(this.search, field, "An attribute of type 'tensor' cannot be 'fast-search'.");
        }
    }

    private void processIndexSettingsForTensorField(SDField field, boolean validate) {
        if (!field.doesIndexing()) {
            return;
        }
        if (this.isTensorTypeThatSupportsHnswIndex(field)) {
            if (validate && !field.doesAttributing()) {
                this.fail(this.search, field, "A tensor that has an index must also be an attribute.");
            }
            Index index = field.getIndex(field.getName());
            HnswIndexParams params = new HnswIndexParams();
            if (index != null && index.getHnswIndexParams().isPresent()) {
                params = params.overrideFrom(index.getHnswIndexParams().get());
            }
            field.getAttribute().setHnswIndexParams(params);
        }
    }

    private void validateDataTypeForCollectionField(SDField field) {
        if (((CollectionDataType)field.getDataType()).getNestedType() instanceof TensorDataType) {
            this.fail(this.search, field, "A field with collection type of tensor is not supported. Use simple type 'tensor' instead.");
        }
    }
}

