/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation.change;

import com.yahoo.config.application.api.ValidationOverrides;
import com.yahoo.config.model.api.ConfigChangeAction;
import com.yahoo.config.model.api.ServiceInfo;
import com.yahoo.documentmodel.NewDocumentType;
import com.yahoo.searchdefinition.derived.AttributeFields;
import com.yahoo.searchdefinition.document.Attribute;
import com.yahoo.vespa.model.VespaModel;
import com.yahoo.vespa.model.application.validation.change.ChangeValidator;
import com.yahoo.vespa.model.application.validation.change.VespaConfigChangeAction;
import com.yahoo.vespa.model.application.validation.change.VespaRestartAction;
import com.yahoo.vespa.model.application.validation.change.search.ChangeMessageBuilder;
import com.yahoo.vespa.model.application.validation.change.search.DocumentTypeChangeValidator;
import com.yahoo.vespa.model.content.cluster.ContentCluster;
import com.yahoo.vespa.model.search.StreamingSearchCluster;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class StreamingSearchClusterChangeValidator
implements ChangeValidator {
    @Override
    public List<ConfigChangeAction> validate(VespaModel current, VespaModel next, ValidationOverrides overrides, Instant now) {
        ArrayList<ConfigChangeAction> result = new ArrayList<ConfigChangeAction>();
        current.getContentClusters().forEach((clusterName, currentCluster) -> {
            ContentCluster nextCluster = next.getContentClusters().get(clusterName);
            if (nextCluster != null) {
                List<StreamingSearchCluster> nextStreamingClusters = nextCluster.getSearch().getStreamingClusters();
                currentCluster.getSearch().getStreamingClusters().forEach(currentStreamingCluster -> {
                    Optional<StreamingSearchCluster> nextStreamingCluster = StreamingSearchClusterChangeValidator.findStreamingCluster(currentStreamingCluster.getClusterName(), nextStreamingClusters);
                    if (nextStreamingCluster.isPresent()) {
                        result.addAll(StreamingSearchClusterChangeValidator.validateStreamingCluster(currentCluster, currentStreamingCluster, nextCluster, nextStreamingCluster.get(), overrides, now));
                    }
                });
            }
        });
        return result;
    }

    private static Optional<StreamingSearchCluster> findStreamingCluster(String clusterName, List<StreamingSearchCluster> clusters) {
        return clusters.stream().filter(cluster -> cluster.getClusterName().equals(clusterName)).findFirst();
    }

    private static List<ConfigChangeAction> validateStreamingCluster(ContentCluster currentCluster, StreamingSearchCluster currentStreamingCluster, ContentCluster nextCluster, StreamingSearchCluster nextStreamingCluster, ValidationOverrides overrides, Instant now) {
        ArrayList<VespaConfigChangeAction> result = new ArrayList<VespaConfigChangeAction>();
        result.addAll(StreamingSearchClusterChangeValidator.validateDocumentTypeChanges(StreamingSearchClusterChangeValidator.getDocumentType(currentCluster, currentStreamingCluster), StreamingSearchClusterChangeValidator.getDocumentType(nextCluster, nextStreamingCluster), overrides, now));
        result.addAll(StreamingSearchClusterChangeValidator.validateAttributeFastAccessAdded(currentStreamingCluster.getSdConfig().getAttributeFields(), nextStreamingCluster.getSdConfig().getAttributeFields()));
        result.addAll(StreamingSearchClusterChangeValidator.validateAttributeFastAccessRemoved(currentStreamingCluster.getSdConfig().getAttributeFields(), nextStreamingCluster.getSdConfig().getAttributeFields()));
        return StreamingSearchClusterChangeValidator.modifyActions(result, StreamingSearchClusterChangeValidator.getSearchNodeServices(nextCluster), nextStreamingCluster.getDocTypeName());
    }

    private static List<VespaConfigChangeAction> validateDocumentTypeChanges(NewDocumentType currentDocType, NewDocumentType nextDocType, ValidationOverrides overrides, Instant now) {
        return new DocumentTypeChangeValidator(currentDocType, nextDocType).validate(overrides, now);
    }

    private static NewDocumentType getDocumentType(ContentCluster cluster, StreamingSearchCluster streamingCluster) {
        return cluster.getDocumentDefinitions().get(streamingCluster.getDocTypeName());
    }

    private static List<VespaConfigChangeAction> validateAttributeFastAccessAdded(AttributeFields currentAttributes, AttributeFields nextAttributes) {
        return StreamingSearchClusterChangeValidator.validateAttributeFastAccessChanged(nextAttributes, currentAttributes, "add");
    }

    private static List<VespaConfigChangeAction> validateAttributeFastAccessRemoved(AttributeFields currentAttributes, AttributeFields nextAttributes) {
        return StreamingSearchClusterChangeValidator.validateAttributeFastAccessChanged(currentAttributes, nextAttributes, "remove");
    }

    private static List<VespaConfigChangeAction> validateAttributeFastAccessChanged(AttributeFields lhsAttributes, AttributeFields rhsAttributes, String change) {
        return lhsAttributes.attributes().stream().filter(attr -> attr.isFastAccess() && !StreamingSearchClusterChangeValidator.hasFastAccessAttribute(attr.getName(), rhsAttributes)).map(attr -> new VespaRestartAction(new ChangeMessageBuilder(attr.getName()).addChange(change + " fast-access attribute").build())).collect(Collectors.toList());
    }

    private static boolean hasFastAccessAttribute(String attrName, AttributeFields attributes) {
        Attribute attr = attributes.getAttribute(attrName);
        return attr != null && attr.isFastAccess();
    }

    private static List<ServiceInfo> getSearchNodeServices(ContentCluster cluster) {
        return cluster.getSearch().getSearchNodes().stream().map(node -> node.getServiceInfo()).collect(Collectors.toList());
    }

    private static List<ConfigChangeAction> modifyActions(List<VespaConfigChangeAction> result, List<ServiceInfo> services, String docTypeName) {
        return result.stream().map(action -> action.modifyAction("Document type '" + docTypeName + "': " + action.getMessage(), services, docTypeName)).collect(Collectors.toList());
    }
}

