/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition;

import com.yahoo.config.FileReference;
import com.yahoo.tensor.TensorType;
import com.yahoo.vespa.model.AbstractService;
import com.yahoo.vespa.model.utils.FileSender;
import java.util.Collection;
import java.util.Objects;

public class RankingConstant {
    private final String name;
    private TensorType tensorType = null;
    private String path = null;
    private String fileReference = "";
    private PathType pathType = PathType.FILE;

    public PathType getPathType() {
        return this.pathType;
    }

    public RankingConstant(String name) {
        this.name = name;
    }

    public RankingConstant(String name, TensorType type, String fileName) {
        this(name);
        this.tensorType = type;
        this.path = fileName;
        this.validate();
    }

    public void setFileName(String fileName) {
        Objects.requireNonNull(fileName, "Filename cannot be null");
        this.path = fileName;
        this.pathType = PathType.FILE;
    }

    public void setUri(String uri) {
        Objects.requireNonNull(uri, "uri cannot be null");
        this.path = uri;
        this.pathType = PathType.URI;
    }

    public void setType(TensorType tensorType) {
        this.tensorType = tensorType;
    }

    public void sendTo(Collection<? extends AbstractService> services) {
        FileReference reference = this.pathType == PathType.FILE ? FileSender.sendFileToServices(this.path, services) : FileSender.sendUriToServices(this.path, services);
        this.fileReference = reference.value();
    }

    public String getName() {
        return this.name;
    }

    public String getFileName() {
        return this.path;
    }

    public String getUri() {
        return this.path;
    }

    public String getFileReference() {
        return this.fileReference;
    }

    public TensorType getTensorType() {
        return this.tensorType;
    }

    public String getType() {
        return this.tensorType.toString();
    }

    public void validate() {
        if (this.path == null || this.path.isEmpty()) {
            throw new IllegalArgumentException("Ranking constants must have a file or uri.");
        }
        if (this.tensorType == null) {
            throw new IllegalArgumentException("Ranking constant '" + this.name + "' must have a type.");
        }
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("constant '").append(this.name).append(this.pathType == PathType.FILE ? "' from file '" : " from uri ").append(this.path).append("' with ref '").append(this.fileReference).append("' of type '").append(this.tensorType).append("'");
        return b.toString();
    }

    public static enum PathType {
        FILE,
        URI;

    }
}

