/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.searchdefinition.RankProfileRegistry;
import com.yahoo.searchdefinition.Search;
import com.yahoo.searchdefinition.document.ComplexAttributeFieldUtils;
import com.yahoo.searchdefinition.document.ImmutableSDField;
import com.yahoo.searchdefinition.processing.Processor;
import com.yahoo.vespa.documentmodel.DocumentSummary;
import com.yahoo.vespa.documentmodel.SummaryField;
import com.yahoo.vespa.documentmodel.SummaryTransform;
import com.yahoo.vespa.model.container.search.QueryProfiles;
import java.util.Map;

public class MatchedElementsOnlyResolver
extends Processor {
    public MatchedElementsOnlyResolver(Search search, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(search, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process(boolean validate, boolean documentsOnly) {
        for (Map.Entry<String, DocumentSummary> entry : this.search.getSummaries().entrySet()) {
            DocumentSummary summary = entry.getValue();
            for (SummaryField field : summary.getSummaryFields()) {
                if (!field.getTransform().equals((Object)SummaryTransform.MATCHED_ELEMENTS_FILTER)) continue;
                this.processSummaryField(summary, field, validate);
            }
        }
    }

    private void processSummaryField(DocumentSummary summary, SummaryField field, boolean validate) {
        ImmutableSDField sourceField = this.search.getField(field.getSingleSource());
        if (sourceField != null) {
            if (ComplexAttributeFieldUtils.isSupportedComplexField(sourceField)) {
                if (ComplexAttributeFieldUtils.isComplexFieldWithOnlyStructFieldAttributes(sourceField)) {
                    field.setTransform(SummaryTransform.MATCHED_ATTRIBUTE_ELEMENTS_FILTER);
                }
            } else if (validate) {
                this.fail(summary, field, "'matched-elements-only' is not supported for this field type. Supported field types are array of simple struct, map of primitive type to simple struct, and map of primitive type to primitive type");
            }
        }
    }

    private void fail(DocumentSummary summary, SummaryField field, String msg) {
        throw new IllegalArgumentException(this.formatError(this.search, summary, field, msg));
    }

    private String formatError(Search search, DocumentSummary summary, SummaryField field, String msg) {
        return "For search '" + search.getName() + "', document summary '" + summary.getName() + "', summary field '" + field.getName() + "': " + msg;
    }
}

