/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.derived;

import com.yahoo.document.ArrayDataType;
import com.yahoo.document.DataType;
import com.yahoo.document.Field;
import com.yahoo.document.StructuredDataType;
import com.yahoo.document.WeightedSetDataType;
import com.yahoo.searchdefinition.Index;
import com.yahoo.searchdefinition.Search;
import com.yahoo.searchdefinition.derived.Derived;
import com.yahoo.searchdefinition.derived.Index;
import com.yahoo.searchdefinition.document.BooleanIndexDefinition;
import com.yahoo.searchdefinition.document.FieldSet;
import com.yahoo.searchdefinition.document.ImmutableSDField;
import com.yahoo.vespa.config.search.IndexschemaConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class IndexSchema
extends Derived
implements IndexschemaConfig.Producer {
    private final List<IndexField> fields = new ArrayList<IndexField>();
    private final Map<String, FieldCollection> collections = new LinkedHashMap<String, FieldCollection>();
    private final Map<String, FieldSet> fieldSets = new LinkedHashMap<String, FieldSet>();

    public IndexSchema(Search search) {
        this.fieldSets.putAll(search.fieldSets().userFieldSets());
        this.derive(search);
    }

    public boolean containsField(String fieldName) {
        return this.fields.stream().anyMatch(field -> field.getName().equals(fieldName));
    }

    @Override
    protected void derive(Search search) {
        super.derive(search);
    }

    private void deriveIndexFields(ImmutableSDField field, Search search) {
        if (!field.doesIndexing() && !field.isIndexStructureField()) {
            return;
        }
        List<Field> lst = IndexSchema.flattenField(field.asField());
        if (lst.isEmpty()) {
            return;
        }
        String fieldName = field.getName();
        for (Field flatField : lst) {
            this.deriveIndexFields(flatField, search);
        }
        if (lst.size() > 1) {
            FieldSet fieldSet = new FieldSet(fieldName);
            for (Field flatField : lst) {
                fieldSet.addFieldName(flatField.getName());
            }
            this.fieldSets.put(fieldName, fieldSet);
        }
    }

    private void deriveIndexFields(Field field, Search search) {
        IndexField toAdd = new IndexField(field.getName(), com.yahoo.searchdefinition.derived.Index.convertType(field.getDataType()), field.getDataType());
        Index definedIndex = search.getIndex(field.getName());
        if (definedIndex != null) {
            toAdd.setIndexSettings(definedIndex);
        }
        this.fields.add(toAdd);
        this.addFieldToCollection(field.getName(), field.getName());
    }

    private FieldCollection getCollection(String collectionName) {
        FieldCollection retval = this.collections.get(collectionName);
        if (retval == null) {
            this.collections.put(collectionName, new FieldCollection(collectionName));
            return this.collections.get(collectionName);
        }
        return retval;
    }

    private void addFieldToCollection(String fieldName, String collectionName) {
        FieldCollection collection = this.getCollection(collectionName);
        collection.fields.add(fieldName);
    }

    @Override
    protected void derive(ImmutableSDField field, Search search) {
        if (field.usesStructOrMap()) {
            return;
        }
        this.deriveIndexFields(field, search);
    }

    @Override
    protected String getDerivedName() {
        return "indexschema";
    }

    public void getConfig(IndexschemaConfig.Builder icB) {
        for (int i = 0; i < this.fields.size(); ++i) {
            IndexField f = this.fields.get(i);
            IndexschemaConfig.Indexfield.Builder ifB = new IndexschemaConfig.Indexfield.Builder().name(f.getName()).datatype(IndexschemaConfig.Indexfield.Datatype.Enum.valueOf((String)f.getType())).prefix(f.hasPrefix()).phrases(f.hasPhrases()).positions(f.hasPositions()).interleavedfeatures(f.useInterleavedFeatures());
            if (!f.getCollectionType().equals("SINGLE")) {
                ifB.collectiontype(IndexschemaConfig.Indexfield.Collectiontype.Enum.valueOf((String)f.getCollectionType()));
            }
            icB.indexfield(ifB);
        }
        for (FieldSet fieldSet : this.fieldSets.values()) {
            IndexschemaConfig.Fieldset.Builder fsB = new IndexschemaConfig.Fieldset.Builder().name(fieldSet.getName());
            for (String f : fieldSet.getFieldNames()) {
                fsB.field(new IndexschemaConfig.Fieldset.Field.Builder().name(f));
            }
            icB.fieldset(fsB);
        }
    }

    static List<Field> flattenField(Field field) {
        DataType fieldType = field.getDataType();
        if (fieldType.getPrimitiveType() != null) {
            return Collections.singletonList(field);
        }
        if (fieldType instanceof ArrayDataType) {
            boolean header = field.isHeader();
            LinkedList<Field> ret = new LinkedList<Field>();
            Field innerField = new Field(field.getName(), ((ArrayDataType)fieldType).getNestedType(), header);
            for (Field flatField : IndexSchema.flattenField(innerField)) {
                ret.add(new Field(flatField.getName(), (DataType)DataType.getArray((DataType)flatField.getDataType()), header));
            }
            return ret;
        }
        if (fieldType instanceof StructuredDataType) {
            LinkedList<Field> ret = new LinkedList<Field>();
            String fieldName = field.getName();
            for (Field childField : ((StructuredDataType)fieldType).getFields()) {
                for (Field flatField : IndexSchema.flattenField(childField)) {
                    ret.add(new Field(fieldName + "." + flatField.getName(), flatField));
                }
            }
            return ret;
        }
        throw new UnsupportedOperationException(fieldType.getName());
    }

    public List<IndexField> getFields() {
        return this.fields;
    }

    private static class FieldCollection {
        private final String name;
        private final List<String> fields = new ArrayList<String>();

        FieldCollection(String name) {
            this.name = name;
        }
    }

    public static class IndexField {
        private String name;
        private Index.Type type;
        private Index.Type sdType;
        private DataType sdFieldType;
        private boolean prefix = false;
        private boolean phrases = false;
        private boolean positions = true;
        private BooleanIndexDefinition boolIndex = null;
        private boolean interleavedFeatures = false;

        public IndexField(String name, Index.Type type, DataType sdFieldType) {
            this.name = name;
            this.type = type;
            this.sdFieldType = sdFieldType;
        }

        public void setIndexSettings(Index index) {
            if (this.type.equals(Index.Type.TEXT)) {
                this.prefix = index.isPrefix();
                this.interleavedFeatures = index.useInterleavedFeatures();
            }
            this.sdType = index.getType();
            this.boolIndex = index.getBooleanIndexDefiniton();
        }

        public String getName() {
            return this.name;
        }

        public Index.Type getRawType() {
            return this.type;
        }

        public String getType() {
            return this.type.equals(Index.Type.INT64) ? "INT64" : "STRING";
        }

        public String getCollectionType() {
            return this.sdFieldType == null ? "SINGLE" : (this.sdFieldType instanceof WeightedSetDataType ? "WEIGHTEDSET" : (this.sdFieldType instanceof ArrayDataType ? "ARRAY" : "SINGLE"));
        }

        public boolean hasPrefix() {
            return this.prefix;
        }

        public boolean hasPhrases() {
            return this.phrases;
        }

        public boolean hasPositions() {
            return this.positions;
        }

        public boolean useInterleavedFeatures() {
            return this.interleavedFeatures;
        }

        public BooleanIndexDefinition getBooleanIndexDefinition() {
            return this.boolIndex;
        }

        public Index.Type getSdType() {
            return this.sdType;
        }
    }
}

