/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.model.provision;

import com.google.common.collect.ImmutableMap;
import com.yahoo.config.model.builder.xml.XmlHelper;
import com.yahoo.config.model.provision.Host;
import com.yahoo.net.HostName;
import com.yahoo.text.XML;
import com.yahoo.vespa.model.builder.xml.dom.VespaDomBuilder;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Hosts {
    public static final Logger log = Logger.getLogger(Hosts.class.getPackage().toString());
    private final ImmutableMap<String, Host> hosts;

    public Hosts(Collection<Host> hosts) {
        this.validateAliases(hosts);
        ImmutableMap.Builder hostsBuilder = new ImmutableMap.Builder();
        for (Host host : hosts) {
            hostsBuilder.put((Object)host.hostname(), (Object)host);
        }
        this.hosts = hostsBuilder.build();
        System.setProperty("zookeeper.vespa.clients", "");
    }

    private void validateAliases(Collection<Host> hosts) {
        HashSet<String> aliases = new HashSet<String>();
        for (Host host : hosts) {
            if (host.aliases().size() <= 0) continue;
            if (host.aliases().size() < 1) {
                throw new IllegalArgumentException("Host '" + host.hostname() + "' must have at least one <alias> tag.");
            }
            for (String alias : host.aliases()) {
                if (aliases.contains(alias)) {
                    throw new IllegalArgumentException("Alias '" + alias + "' is used by multiple hosts.");
                }
                aliases.add(alias);
            }
        }
    }

    public static Hosts readFrom(Reader hostsFile) {
        Document doc;
        ArrayList<Host> hosts = new ArrayList<Host>();
        try {
            doc = XmlHelper.getDocumentBuilder().parse(new InputSource(hostsFile));
        }
        catch (IOException | SAXException e) {
            throw new IllegalArgumentException(e);
        }
        for (Element hostE : XML.getChildren((Element)doc.getDocumentElement(), (String)"host")) {
            List<String> hostAliases;
            String name = hostE.getAttribute("name");
            if (name.equals("")) {
                throw new RuntimeException("Missing 'name' attribute for host.");
            }
            if ("localhost".equals(name)) {
                name = HostName.getLocalhost();
            }
            if ((hostAliases = VespaDomBuilder.getHostAliases(hostE.getChildNodes())).isEmpty()) {
                throw new IllegalArgumentException("No host aliases defined for host '" + name + "'");
            }
            hosts.add(new Host(name, hostAliases));
        }
        return new Hosts(hosts);
    }

    public Collection<Host> asCollection() {
        return this.hosts.values();
    }

    public String toString() {
        return "Hosts: " + this.hosts.keySet();
    }
}

