/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.http.xml;

import com.yahoo.config.model.builder.xml.XmlHelper;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.text.XML;
import com.yahoo.vespa.model.builder.xml.dom.ModelElement;
import com.yahoo.vespa.model.builder.xml.dom.VespaDomBuilder;
import com.yahoo.vespa.model.container.component.SimpleComponent;
import com.yahoo.vespa.model.container.http.ConnectorFactory;
import com.yahoo.vespa.model.container.http.ssl.ConfiguredFilebasedSslProvider;
import com.yahoo.vespa.model.container.http.ssl.CustomSslProvider;
import com.yahoo.vespa.model.container.http.ssl.DefaultSslProvider;
import com.yahoo.vespa.model.container.http.xml.HttpBuilder;
import java.util.Optional;
import org.w3c.dom.Element;

public class JettyConnectorBuilder
extends VespaDomBuilder.DomConfigProducerBuilder<ConnectorFactory> {
    @Override
    protected ConnectorFactory doBuild(DeployState deployState, AbstractConfigProducer ancestor, Element serverSpec) {
        String name = XmlHelper.getIdString(serverSpec);
        int port = HttpBuilder.readPort(new ModelElement(serverSpec), deployState.isHosted(), deployState.getDeployLogger());
        SimpleComponent sslProviderComponent = this.getSslConfigComponents(name, serverSpec);
        return new ConnectorFactory(name, port, sslProviderComponent);
    }

    SimpleComponent getSslConfigComponents(String serverName, Element serverSpec) {
        Element sslConfigurator = XML.getChild((Element)serverSpec, (String)"ssl");
        Element sslProviderConfigurator = XML.getChild((Element)serverSpec, (String)"ssl-provider");
        if (sslConfigurator != null) {
            String privateKeyFile = XML.getValue((Element)XML.getChild((Element)sslConfigurator, (String)"private-key-file"));
            String certificateFile = XML.getValue((Element)XML.getChild((Element)sslConfigurator, (String)"certificate-file"));
            Optional<String> caCertificateFile = XmlHelper.getOptionalChildValue(sslConfigurator, "ca-certificates-file");
            Optional<String> clientAuthentication = XmlHelper.getOptionalChildValue(sslConfigurator, "client-authentication");
            return new ConfiguredFilebasedSslProvider(serverName, privateKeyFile, certificateFile, caCertificateFile.orElse(null), clientAuthentication.orElse(null));
        }
        if (sslProviderConfigurator != null) {
            String className = sslProviderConfigurator.getAttribute("class");
            String bundle = sslProviderConfigurator.getAttribute("bundle");
            return new CustomSslProvider(serverName, className, bundle);
        }
        return new DefaultSslProvider(serverName);
    }
}

