/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.application.api.ValidationOverrides;
import com.yahoo.config.model.api.ConfigChangeAction;
import com.yahoo.config.model.api.Model;
import com.yahoo.config.model.api.ValidationParameters;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.vespa.model.VespaModel;
import com.yahoo.vespa.model.application.validation.AccessControlFilterValidator;
import com.yahoo.vespa.model.application.validation.ComplexAttributeFieldsValidator;
import com.yahoo.vespa.model.application.validation.ComponentValidator;
import com.yahoo.vespa.model.application.validation.DeploymentSpecValidator;
import com.yahoo.vespa.model.application.validation.EndpointCertificateSecretsValidator;
import com.yahoo.vespa.model.application.validation.NoPrefixForIndexes;
import com.yahoo.vespa.model.application.validation.RankSetupValidator;
import com.yahoo.vespa.model.application.validation.RankingConstantsValidator;
import com.yahoo.vespa.model.application.validation.RoutingSelectorValidator;
import com.yahoo.vespa.model.application.validation.RoutingValidator;
import com.yahoo.vespa.model.application.validation.SearchDataTypeValidator;
import com.yahoo.vespa.model.application.validation.SecretStoreValidator;
import com.yahoo.vespa.model.application.validation.StreamingValidator;
import com.yahoo.vespa.model.application.validation.change.ChangeValidator;
import com.yahoo.vespa.model.application.validation.change.ClusterSizeReductionValidator;
import com.yahoo.vespa.model.application.validation.change.ConfigValueChangeValidator;
import com.yahoo.vespa.model.application.validation.change.ContainerRestartValidator;
import com.yahoo.vespa.model.application.validation.change.ContentClusterRemovalValidator;
import com.yahoo.vespa.model.application.validation.change.ContentTypeRemovalValidator;
import com.yahoo.vespa.model.application.validation.change.GlobalDocumentChangeValidator;
import com.yahoo.vespa.model.application.validation.change.IndexedSearchClusterChangeValidator;
import com.yahoo.vespa.model.application.validation.change.IndexingModeChangeValidator;
import com.yahoo.vespa.model.application.validation.change.ResourcesReductionValidator;
import com.yahoo.vespa.model.application.validation.change.StartupCommandChangeValidator;
import com.yahoo.vespa.model.application.validation.change.StreamingSearchClusterChangeValidator;
import com.yahoo.vespa.model.application.validation.first.AccessControlOnFirstDeploymentValidator;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class Validation {
    public static List<ConfigChangeAction> validate(VespaModel model, ValidationParameters validationParameters, DeployState deployState) {
        if (validationParameters.checkRouting()) {
            new RoutingValidator().validate(model, deployState);
            new RoutingSelectorValidator().validate(model, deployState);
        }
        new ComponentValidator().validate(model, deployState);
        new SearchDataTypeValidator().validate(model, deployState);
        new ComplexAttributeFieldsValidator().validate(model, deployState);
        new StreamingValidator().validate(model, deployState);
        new RankSetupValidator(validationParameters.ignoreValidationErrors()).validate(model, deployState);
        new NoPrefixForIndexes().validate(model, deployState);
        new DeploymentSpecValidator().validate(model, deployState);
        new RankingConstantsValidator().validate(model, deployState);
        new SecretStoreValidator().validate(model, deployState);
        new EndpointCertificateSecretsValidator().validate(model, deployState);
        new AccessControlFilterValidator().validate(model, deployState);
        List<ConfigChangeAction> result = Collections.emptyList();
        if (deployState.getProperties().isFirstTimeDeployment()) {
            Validation.validateFirstTimeDeployment(model, deployState);
        } else {
            Optional<Model> currentActiveModel = deployState.getPreviousModel();
            if (currentActiveModel.isPresent() && currentActiveModel.get() instanceof VespaModel) {
                result = Validation.validateChanges((VespaModel)currentActiveModel.get(), model, deployState.validationOverrides(), deployState.getDeployLogger(), deployState.now());
            }
        }
        return result;
    }

    private static List<ConfigChangeAction> validateChanges(VespaModel currentModel, VespaModel nextModel, ValidationOverrides overrides, DeployLogger logger, Instant now) {
        ChangeValidator[] validators = new ChangeValidator[]{new IndexingModeChangeValidator(), new GlobalDocumentChangeValidator(), new IndexedSearchClusterChangeValidator(), new StreamingSearchClusterChangeValidator(), new ConfigValueChangeValidator(logger), new StartupCommandChangeValidator(), new ContentTypeRemovalValidator(), new ContentClusterRemovalValidator(), new ClusterSizeReductionValidator(), new ResourcesReductionValidator(), new ContainerRestartValidator()};
        return Arrays.stream(validators).flatMap(v -> v.validate(currentModel, nextModel, overrides, now).stream()).collect(Collectors.toList());
    }

    private static void validateFirstTimeDeployment(VespaModel model, DeployState deployState) {
        new AccessControlOnFirstDeploymentValidator().validate(model, deployState);
    }
}

