/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.expressiontransforms;

import com.yahoo.searchdefinition.RankProfile;
import com.yahoo.searchdefinition.expressiontransforms.RankProfileTransformContext;
import com.yahoo.searchlib.rankingexpression.RankingExpression;
import com.yahoo.searchlib.rankingexpression.rule.CompositeNode;
import com.yahoo.searchlib.rankingexpression.rule.ExpressionNode;
import com.yahoo.searchlib.rankingexpression.rule.FunctionNode;
import com.yahoo.searchlib.rankingexpression.rule.ReferenceNode;
import com.yahoo.searchlib.rankingexpression.transform.ExpressionTransformer;

public class FunctionShadower
extends ExpressionTransformer<RankProfileTransformContext> {
    public RankingExpression transform(RankingExpression expression, RankProfileTransformContext context) {
        String name = expression.getName();
        ExpressionNode node = expression.getRoot();
        ExpressionNode result = this.transform(node, context);
        return new RankingExpression(name, result);
    }

    public ExpressionNode transform(ExpressionNode node, RankProfileTransformContext context) {
        if (node instanceof FunctionNode) {
            return this.transformFunctionNode((FunctionNode)node, context);
        }
        if (node instanceof CompositeNode) {
            return this.transformChildren((CompositeNode)node, context);
        }
        return node;
    }

    private ExpressionNode transformFunctionNode(FunctionNode function, RankProfileTransformContext context) {
        String name = function.getFunction().toString();
        RankProfile.RankingExpressionFunction rankingExpressionFunction = context.rankProfile().findFunction(name);
        if (rankingExpressionFunction == null) {
            return this.transformChildren((CompositeNode)function, context);
        }
        int functionArity = function.getFunction().arity();
        if (functionArity != rankingExpressionFunction.function().arguments().size()) {
            return this.transformChildren((CompositeNode)function, context);
        }
        ReferenceNode node = new ReferenceNode(name, function.children(), null);
        return this.transformChildren((CompositeNode)node, context);
    }
}

