/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.xml;

import com.yahoo.config.model.ConfigModelContext;
import com.yahoo.vespa.model.container.ApplicationContainerCluster;
import com.yahoo.vespa.model.container.ContainerModel;
import com.yahoo.vespa.model.container.configserver.ConfigserverCluster;
import com.yahoo.vespa.model.container.configserver.option.CloudConfigOptions;
import com.yahoo.vespa.model.container.xml.ContainerModelBuilder;
import org.w3c.dom.Element;

public class ConfigServerContainerModelBuilder
extends ContainerModelBuilder {
    private final CloudConfigOptions options;

    public ConfigServerContainerModelBuilder(CloudConfigOptions options) {
        super(true, ContainerModelBuilder.Networking.enable);
        this.options = options;
    }

    @Override
    public void doBuild(ContainerModel model, Element spec, ConfigModelContext modelContext) {
        ConfigserverCluster cluster = new ConfigserverCluster(modelContext.getParentProducer(), "configserver", this.options);
        super.doBuild(model, spec, modelContext.withParent(cluster));
        cluster.setContainerCluster(model.getCluster());
    }

    @Override
    protected void addStatusHandlers(ApplicationContainerCluster cluster, boolean isHostedVespa) {
        super.addStatusHandlers(cluster, this.options.hostedVespa().orElse(Boolean.FALSE));
    }
}

