/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.http.ssl;

import com.yahoo.config.model.api.TlsSecrets;
import com.yahoo.jdisc.http.ConnectorConfig;
import com.yahoo.vespa.model.container.component.SimpleComponent;
import com.yahoo.vespa.model.container.http.ConnectorFactory;
import com.yahoo.vespa.model.container.http.ssl.ConfiguredDirectSslProvider;
import com.yahoo.vespa.model.container.http.ssl.DefaultSslProvider;
import java.util.List;

public class HostedSslConnectorFactory
extends ConnectorFactory {
    private static final List<String> INSECURE_WHITELISTED_PATHS = List.of("/status.html");
    private final boolean enforceClientAuth;

    public static HostedSslConnectorFactory withProvidedCertificate(String serverName, TlsSecrets tlsSecrets) {
        return new HostedSslConnectorFactory(HostedSslConnectorFactory.createConfiguredDirectSslProvider(serverName, tlsSecrets, null), false);
    }

    public static HostedSslConnectorFactory withProvidedCertificateAndTruststore(String serverName, TlsSecrets tlsSecrets, String tlsCaCertificates) {
        return new HostedSslConnectorFactory(HostedSslConnectorFactory.createConfiguredDirectSslProvider(serverName, tlsSecrets, tlsCaCertificates), true);
    }

    public static HostedSslConnectorFactory withDefaultCertificateAndTruststore(String serverName) {
        return new HostedSslConnectorFactory(new DefaultSslProvider(serverName), true);
    }

    private HostedSslConnectorFactory(SimpleComponent sslProviderComponent, boolean enforceClientAuth) {
        super("tls4443", 4443, sslProviderComponent);
        this.enforceClientAuth = enforceClientAuth;
    }

    private static ConfiguredDirectSslProvider createConfiguredDirectSslProvider(String serverName, TlsSecrets tlsSecrets, String tlsCaCertificates) {
        return new ConfiguredDirectSslProvider(serverName, tlsSecrets.key(), tlsSecrets.certificate(), null, tlsCaCertificates, ConnectorConfig.Ssl.ClientAuth.Enum.WANT_AUTH);
    }

    @Override
    public void getConfig(ConnectorConfig.Builder connectorBuilder) {
        super.getConfig(connectorBuilder);
        connectorBuilder.tlsClientAuthEnforcer(new ConnectorConfig.TlsClientAuthEnforcer.Builder().pathWhitelist(INSECURE_WHITELISTED_PATHS).enable(this.enforceClientAuth));
    }
}

