/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition;

import com.yahoo.searchdefinition.Search;
import com.yahoo.searchdefinition.document.BooleanIndexDefinition;
import com.yahoo.searchdefinition.document.RankType;
import com.yahoo.searchdefinition.document.Stemming;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

public class Index
implements Cloneable,
Serializable {
    private String name;
    private RankType rankType = null;
    private boolean prefix;
    private Set<String> aliases = new LinkedHashSet<String>(1);
    private Stemming stemming = null;
    private boolean normalized = true;
    private Type type = Type.VESPA;
    private BooleanIndexDefinition boolIndex;
    private boolean interleavedFeatures = false;

    public Index(String name) {
        this(name, false);
    }

    public Index(String name, boolean prefix) {
        this.name = name;
        this.prefix = prefix;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setRankType(RankType rankType) {
        this.rankType = rankType;
    }

    public RankType getRankType() {
        return this.rankType;
    }

    public Stemming getStemming() {
        return this.stemming;
    }

    public Stemming getStemming(Search search) {
        if (this.stemming != null) {
            return this.stemming;
        }
        return search.getStemming();
    }

    public void setStemming(Stemming stemming) {
        this.stemming = stemming;
    }

    public boolean isPrefix() {
        return this.prefix;
    }

    public void setPrefix(boolean prefix) {
        this.prefix = prefix;
    }

    public void addAlias(String alias) {
        this.aliases.add(alias);
    }

    public Iterator<String> aliasIterator() {
        return Collections.unmodifiableSet(this.aliases).iterator();
    }

    public int hashCode() {
        return this.name.hashCode() + (this.prefix ? 17 : 0);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Index)) {
            return false;
        }
        Index other = (Index)object;
        return this.name.equals(other.name) && this.prefix == other.prefix && this.stemming == other.stemming && this.normalized == other.normalized;
    }

    public String toString() {
        String rankTypeName = this.rankType == null ? "(none)" : this.rankType.name();
        return "index '" + this.name + "' [ranktype: " + rankTypeName + ", prefix: " + this.prefix + "]";
    }

    public Object clone() {
        try {
            Index copy = (Index)super.clone();
            copy.aliases = new LinkedHashSet<String>(this.aliases);
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Programming error", e);
        }
    }

    public Index copy() {
        return (Index)this.clone();
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public BooleanIndexDefinition getBooleanIndexDefiniton() {
        return this.boolIndex;
    }

    public void setBooleanIndexDefiniton(BooleanIndexDefinition def) {
        this.boolIndex = def;
    }

    public void setInterleavedFeatures(boolean value) {
        this.interleavedFeatures = value;
    }

    public boolean useInterleavedFeatures() {
        return this.interleavedFeatures;
    }

    public static enum Type {
        VESPA("vespa");

        private String name;

        private Type(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

