/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.search;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.vespa.model.HostResource;
import com.yahoo.vespa.model.SimpleConfigProducer;
import com.yahoo.vespa.model.content.DispatchSpec;
import com.yahoo.vespa.model.search.Dispatch;
import com.yahoo.vespa.model.search.DispatchGroup;
import com.yahoo.vespa.model.search.IndexedSearchCluster;
import com.yahoo.vespa.model.search.NodeSpec;
import com.yahoo.vespa.model.search.SearchInterface;
import com.yahoo.vespa.model.search.SearchNode;
import com.yahoo.vespa.model.search.SearchNodeWrapper;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DispatchGroupBuilder {
    private final SimpleConfigProducer dispatchParent;
    private final DispatchGroup rootDispatch;
    private final IndexedSearchCluster searchCluster;

    public DispatchGroupBuilder(SimpleConfigProducer dispatchParent, DispatchGroup rootDispatch, IndexedSearchCluster searchCluster) {
        this.dispatchParent = dispatchParent;
        this.rootDispatch = rootDispatch;
        this.searchCluster = searchCluster;
    }

    public void build(DeployLogger deployLogger, List<DispatchSpec.Group> groupsSpec, List<SearchNode> searchNodes) {
        Map<Integer, SearchNode> searchNodeMap = DispatchGroupBuilder.buildSearchNodeMap(searchNodes);
        for (int partId = 0; partId < groupsSpec.size(); ++partId) {
            DispatchSpec.Group groupSpec = groupsSpec.get(partId);
            DispatchGroup group = new DispatchGroup(this.searchCluster);
            this.populateDispatchGroup(deployLogger, group, groupSpec.getNodes(), searchNodeMap, partId);
        }
    }

    private void populateDispatchGroup(DeployLogger deployLogger, DispatchGroup group, List<DispatchSpec.Node> nodeList, Map<Integer, SearchNode> searchNodesMap, int partId) {
        for (int rowId = 0; rowId < nodeList.size(); ++rowId) {
            int distributionKey = nodeList.get(rowId).getDistributionKey();
            SearchNode searchNode = searchNodesMap.get(distributionKey);
            Dispatch dispatch = this.buildDispatch(deployLogger, group, new NodeSpec(rowId, partId), distributionKey, searchNode.getHostResource());
            group.addDispatcher(dispatch);
            this.rootDispatch.addSearcher(dispatch);
            group.addSearcher(DispatchGroupBuilder.buildSearchInterface(searchNode, rowId));
        }
    }

    private Dispatch buildDispatch(DeployLogger deployLogger, DispatchGroup group, NodeSpec nodeSpec, int distributionKey, HostResource hostResource) {
        Dispatch dispatch = Dispatch.createDispatchWithStableConfigId(group, this.dispatchParent, nodeSpec, distributionKey, 1);
        dispatch.setHostResource(hostResource);
        dispatch.initService(deployLogger);
        return dispatch;
    }

    private static SearchInterface buildSearchInterface(SearchNode searchNode, int partId) {
        searchNode.updatePartition(partId);
        return new SearchNodeWrapper(new NodeSpec(0, partId), searchNode);
    }

    private static Map<Integer, SearchNode> buildSearchNodeMap(List<SearchNode> searchNodes) {
        LinkedHashMap<Integer, SearchNode> retval = new LinkedHashMap<Integer, SearchNode>();
        for (SearchNode node : searchNodes) {
            retval.put(node.getDistributionKey(), node);
        }
        return retval;
    }

    public static List<DispatchSpec.Group> createDispatchGroups(List<SearchNode> searchNodes, int numDispatchGroups) {
        if (numDispatchGroups > searchNodes.size()) {
            numDispatchGroups = searchNodes.size();
        }
        ArrayList<DispatchSpec.Group> groupsSpec = new ArrayList<DispatchSpec.Group>();
        int numNodesPerGroup = searchNodes.size() / numDispatchGroups;
        if (searchNodes.size() % numDispatchGroups != 0) {
            ++numNodesPerGroup;
        }
        int searchNodeIdx = 0;
        for (int i = 0; i < numDispatchGroups; ++i) {
            DispatchSpec.Group groupSpec = new DispatchSpec.Group();
            for (int j = 0; j < numNodesPerGroup && searchNodeIdx < searchNodes.size(); ++j) {
                groupSpec.addNode(new DispatchSpec.Node(searchNodes.get(searchNodeIdx++).getDistributionKey()));
            }
            groupsSpec.add(groupSpec);
        }
        assert (searchNodeIdx == searchNodes.size());
        return groupsSpec;
    }
}

